/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HangingMossBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class PaleMossDecorator
extends TreeDecorator {
    public static final MapCodec<PaleMossDecorator> CODEC = RecordCodecBuilder.mapCodec($$02 -> $$02.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("leaves_probability").forGetter($$0 -> Float.valueOf($$0.leavesProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("trunk_probability").forGetter($$0 -> Float.valueOf($$0.trunkProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("ground_probability").forGetter($$0 -> Float.valueOf($$0.groundProbability))).apply((Applicative)$$02, PaleMossDecorator::new));
    private final float leavesProbability;
    private final float trunkProbability;
    private final float groundProbability;

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.PALE_MOSS;
    }

    public PaleMossDecorator(float $$0, float $$1, float $$2) {
        this.leavesProbability = $$0;
        this.trunkProbability = $$1;
        this.groundProbability = $$2;
    }

    @Override
    public void place(TreeDecorator.Context $$02) {
        RandomSource $$1 = $$02.random();
        WorldGenLevel $$22 = (WorldGenLevel)$$02.level();
        List<BlockPos> $$32 = Util.shuffledCopy($$02.logs(), $$1);
        if ($$32.isEmpty()) {
            return;
        }
        BlockPos $$4 = Collections.min($$32, Comparator.comparingInt(Vec3i::getY));
        if ($$1.nextFloat() < this.groundProbability) {
            $$22.registryAccess().lookup(Registries.CONFIGURED_FEATURE).flatMap($$0 -> $$0.get(VegetationFeatures.PALE_MOSS_PATCH)).ifPresent($$3 -> ((ConfiguredFeature)$$3.value()).place($$22, $$22.getLevel().getChunkSource().getGenerator(), $$1, $$4.above()));
        }
        $$02.logs().forEach($$2 -> {
            BlockPos $$3;
            if ($$1.nextFloat() < this.trunkProbability && $$02.isAir($$3 = $$2.below())) {
                PaleMossDecorator.addMossHanger($$3, $$02);
            }
        });
        $$02.leaves().forEach($$2 -> {
            BlockPos $$3;
            if ($$1.nextFloat() < this.leavesProbability && $$02.isAir($$3 = $$2.below())) {
                PaleMossDecorator.addMossHanger($$3, $$02);
            }
        });
    }

    private static void addMossHanger(BlockPos $$0, TreeDecorator.Context $$1) {
        while ($$1.isAir($$0.below()) && !((double)$$1.random().nextFloat() < 0.5)) {
            $$1.setBlock($$0, (BlockState)Blocks.PALE_HANGING_MOSS.defaultBlockState().setValue(HangingMossBlock.TIP, false));
            $$0 = $$0.below();
        }
        $$1.setBlock($$0, (BlockState)Blocks.PALE_HANGING_MOSS.defaultBlockState().setValue(HangingMossBlock.TIP, true));
    }
}

