/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jspecify.annotations.Nullable;

public interface LootContextArg<R> {
    public static final Codec<LootContextArg<Object>> ENTITY_OR_BLOCK = LootContextArg.createArgCodec($$0 -> $$0.anyOf(LootContext.EntityTarget.values()).anyOf(LootContext.BlockEntityTarget.values()));

    public @Nullable R get(LootContext var1);

    public ContextKey<?> contextParam();

    public static <U> LootContextArg<U> cast(LootContextArg<? extends U> $$0) {
        return $$0;
    }

    public static <R> Codec<LootContextArg<R>> createArgCodec(UnaryOperator<ArgCodecBuilder<R>> $$0) {
        return ((ArgCodecBuilder)$$0.apply(new ArgCodecBuilder())).build();
    }

    public static final class ArgCodecBuilder<R> {
        private final ExtraCodecs.LateBoundIdMapper<String, LootContextArg<R>> sources = new ExtraCodecs.LateBoundIdMapper();

        ArgCodecBuilder() {
        }

        public <T> ArgCodecBuilder<R> anyOf(T[] $$0, Function<T, String> $$1, Function<T, ? extends LootContextArg<R>> $$2) {
            for (T $$3 : $$0) {
                this.sources.put($$1.apply($$3), $$2.apply($$3));
            }
            return this;
        }

        public <T extends StringRepresentable> ArgCodecBuilder<R> anyOf(T[] $$0, Function<T, ? extends LootContextArg<R>> $$1) {
            return this.anyOf($$0, StringRepresentable::getSerializedName, $$1);
        }

        public <T extends StringRepresentable & LootContextArg<? extends R>> ArgCodecBuilder<R> anyOf(T[] $$02) {
            return this.anyOf((StringRepresentable[])$$02, $$0 -> LootContextArg.cast((LootContextArg)$$0));
        }

        public ArgCodecBuilder<R> anyEntity(Function<? super ContextKey<? extends Entity>, ? extends LootContextArg<R>> $$0) {
            return this.anyOf(LootContext.EntityTarget.values(), $$1 -> (LootContextArg)$$0.apply($$1.contextParam()));
        }

        public ArgCodecBuilder<R> anyBlockEntity(Function<? super ContextKey<? extends BlockEntity>, ? extends LootContextArg<R>> $$0) {
            return this.anyOf(LootContext.BlockEntityTarget.values(), $$1 -> (LootContextArg)$$0.apply($$1.contextParam()));
        }

        public ArgCodecBuilder<R> anyItemStack(Function<? super ContextKey<? extends ItemStack>, ? extends LootContextArg<R>> $$0) {
            return this.anyOf(LootContext.ItemStackTarget.values(), $$1 -> (LootContextArg)$$0.apply($$1.contextParam()));
        }

        Codec<LootContextArg<R>> build() {
            return this.sources.codec((Codec<String>)Codec.STRING);
        }
    }

    public static interface SimpleGetter<T>
    extends LootContextArg<T> {
        @Override
        public ContextKey<? extends T> contextParam();

        @Override
        default public @Nullable T get(LootContext $$0) {
            return $$0.getOptionalParameter(this.contextParam());
        }
    }

    public static interface Getter<T, R>
    extends LootContextArg<R> {
        public @Nullable R get(T var1);

        @Override
        public ContextKey<? extends T> contextParam();

        @Override
        default public @Nullable R get(LootContext $$0) {
            T $$1 = $$0.getOptionalParameter(this.contextParam());
            return $$1 != null ? (R)this.get($$1) : null;
        }
    }
}

