/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Util;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootContextArg;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class CopyComponentsFunction
extends LootItemConditionalFunction {
    private static final Codec<LootContextArg<DataComponentGetter>> GETTER_CODEC = LootContextArg.createArgCodec($$0 -> $$0.anyEntity(DirectSource::new).anyBlockEntity(BlockEntitySource::new).anyItemStack(DirectSource::new));
    public static final MapCodec<CopyComponentsFunction> CODEC = RecordCodecBuilder.mapCodec($$02 -> CopyComponentsFunction.commonFields($$02).and($$02.group((App)GETTER_CODEC.fieldOf("source").forGetter($$0 -> $$0.source), (App)DataComponentType.CODEC.listOf().optionalFieldOf("include").forGetter($$0 -> $$0.include), (App)DataComponentType.CODEC.listOf().optionalFieldOf("exclude").forGetter($$0 -> $$0.exclude))).apply((Applicative)$$02, CopyComponentsFunction::new));
    private final LootContextArg<DataComponentGetter> source;
    private final Optional<List<DataComponentType<?>>> include;
    private final Optional<List<DataComponentType<?>>> exclude;
    private final Predicate<DataComponentType<?>> bakedPredicate;

    CopyComponentsFunction(List<LootItemCondition> $$0, LootContextArg<DataComponentGetter> $$13, Optional<List<DataComponentType<?>>> $$2, Optional<List<DataComponentType<?>>> $$3) {
        super($$0);
        this.source = $$13;
        this.include = $$2.map(List::copyOf);
        this.exclude = $$3.map(List::copyOf);
        ArrayList $$4 = new ArrayList(2);
        $$3.ifPresent($$12 -> $$4.add($$1 -> !$$12.contains($$1)));
        $$2.ifPresent($$1 -> $$4.add($$1::contains));
        this.bakedPredicate = Util.allOf($$4);
    }

    public LootItemFunctionType<CopyComponentsFunction> getType() {
        return LootItemFunctions.COPY_COMPONENTS;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(this.source.contextParam());
    }

    @Override
    public ItemStack run(ItemStack $$0, LootContext $$1) {
        DataComponentGetter $$2 = this.source.get($$1);
        if ($$2 != null) {
            if ($$2 instanceof DataComponentMap) {
                DataComponentMap $$32 = (DataComponentMap)$$2;
                $$0.applyComponents($$32.filter(this.bakedPredicate));
            } else {
                Collection $$4 = this.exclude.orElse(List.of());
                this.include.map(Collection::stream).orElse(BuiltInRegistries.DATA_COMPONENT_TYPE.listElements().map(Holder::value)).forEach($$3 -> {
                    if ($$4.contains($$3)) {
                        return;
                    }
                    TypedDataComponent $$4 = $$2.getTyped($$3);
                    if ($$4 != null) {
                        $$0.set($$4);
                    }
                });
            }
        }
        return $$0;
    }

    public static Builder copyComponentsFromEntity(ContextKey<? extends Entity> $$0) {
        return new Builder(new DirectSource<Entity>($$0));
    }

    public static Builder copyComponentsFromBlockEntity(ContextKey<? extends BlockEntity> $$0) {
        return new Builder(new BlockEntitySource($$0));
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final LootContextArg<DataComponentGetter> source;
        private Optional<ImmutableList.Builder<DataComponentType<?>>> include = Optional.empty();
        private Optional<ImmutableList.Builder<DataComponentType<?>>> exclude = Optional.empty();

        Builder(LootContextArg<DataComponentGetter> $$0) {
            this.source = $$0;
        }

        public Builder include(DataComponentType<?> $$0) {
            if (this.include.isEmpty()) {
                this.include = Optional.of(ImmutableList.builder());
            }
            this.include.get().add($$0);
            return this;
        }

        public Builder exclude(DataComponentType<?> $$0) {
            if (this.exclude.isEmpty()) {
                this.exclude = Optional.of(ImmutableList.builder());
            }
            this.exclude.get().add($$0);
            return this;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new CopyComponentsFunction(this.getConditions(), this.source, this.include.map(ImmutableList.Builder::build), this.exclude.map(ImmutableList.Builder::build));
        }

        @Override
        protected /* synthetic */ LootItemConditionalFunction.Builder getThis() {
            return this.getThis();
        }
    }

    record DirectSource<T extends DataComponentGetter>(ContextKey<? extends T> contextParam) implements LootContextArg.Getter<T, DataComponentGetter>
    {
        @Override
        public DataComponentGetter get(T $$0) {
            return $$0;
        }
    }

    record BlockEntitySource(ContextKey<? extends BlockEntity> contextParam) implements LootContextArg.Getter<BlockEntity, DataComponentGetter>
    {
        @Override
        public DataComponentGetter get(BlockEntity $$0) {
            return $$0.collectComponents();
        }
    }
}

