/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class FilteredFunction
extends LootItemConditionalFunction {
    public static final MapCodec<FilteredFunction> CODEC = RecordCodecBuilder.mapCodec($$02 -> FilteredFunction.commonFields($$02).and($$02.group((App)ItemPredicate.CODEC.fieldOf("item_filter").forGetter($$0 -> $$0.filter), (App)LootItemFunctions.ROOT_CODEC.optionalFieldOf("on_pass").forGetter($$0 -> $$0.onPass), (App)LootItemFunctions.ROOT_CODEC.optionalFieldOf("on_fail").forGetter($$0 -> $$0.onFail))).apply((Applicative)$$02, FilteredFunction::new));
    private final ItemPredicate filter;
    private final Optional<LootItemFunction> onPass;
    private final Optional<LootItemFunction> onFail;

    FilteredFunction(List<LootItemCondition> $$0, ItemPredicate $$1, Optional<LootItemFunction> $$2, Optional<LootItemFunction> $$3) {
        super($$0);
        this.filter = $$1;
        this.onPass = $$2;
        this.onFail = $$3;
    }

    public LootItemFunctionType<FilteredFunction> getType() {
        return LootItemFunctions.FILTERED;
    }

    @Override
    public ItemStack run(ItemStack $$0, LootContext $$1) {
        Optional<LootItemFunction> $$2;
        Optional<LootItemFunction> optional = $$2 = this.filter.test($$0) ? this.onPass : this.onFail;
        if ($$2.isPresent()) {
            return (ItemStack)$$2.get().apply($$0, $$1);
        }
        return $$0;
    }

    @Override
    public void validate(ValidationContext $$0) {
        super.validate($$0);
        this.onPass.ifPresent($$1 -> $$1.validate($$0.forChild(new ProblemReporter.FieldPathElement("on_pass"))));
        this.onFail.ifPresent($$1 -> $$1.validate($$0.forChild(new ProblemReporter.FieldPathElement("on_fail"))));
    }

    public static Builder filtered(ItemPredicate $$0) {
        return new Builder($$0);
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final ItemPredicate itemPredicate;
        private Optional<LootItemFunction> onPass = Optional.empty();
        private Optional<LootItemFunction> onFail = Optional.empty();

        Builder(ItemPredicate $$0) {
            this.itemPredicate = $$0;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder onPass(Optional<LootItemFunction> $$0) {
            this.onPass = $$0;
            return this;
        }

        public Builder onFail(Optional<LootItemFunction> $$0) {
            this.onFail = $$0;
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new FilteredFunction(this.getConditions(), this.itemPredicate, this.onPass, this.onFail);
        }

        @Override
        protected /* synthetic */ LootItemConditionalFunction.Builder getThis() {
            return this.getThis();
        }
    }
}

