/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.timeline;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.KeyframeTrack;
import net.minecraft.util.Util;
import net.minecraft.world.attribute.EnvironmentAttribute;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.attribute.modifier.AttributeModifier;
import net.minecraft.world.level.Level;
import net.minecraft.world.timeline.AttributeTrack;
import net.minecraft.world.timeline.AttributeTrackSampler;

public class Timeline {
    public static final Codec<Holder<Timeline>> CODEC = RegistryFixedCodec.create(Registries.TIMELINE);
    private static final Codec<Map<EnvironmentAttribute<?>, AttributeTrack<?, ?>>> TRACKS_CODEC = Codec.dispatchedMap(EnvironmentAttributes.CODEC, Util.memoize(AttributeTrack::createCodec));
    public static final Codec<Timeline> DIRECT_CODEC = RecordCodecBuilder.create($$02 -> $$02.group((App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("period_ticks").forGetter($$0 -> $$0.periodTicks), (App)TRACKS_CODEC.optionalFieldOf("tracks", Map.of()).forGetter($$0 -> $$0.tracks)).apply((Applicative)$$02, Timeline::new)).validate(Timeline::validateInternal);
    public static final Codec<Timeline> NETWORK_CODEC = DIRECT_CODEC.xmap(Timeline::filterSyncableTracks, Timeline::filterSyncableTracks);
    private final Optional<Integer> periodTicks;
    private final Map<EnvironmentAttribute<?>, AttributeTrack<?, ?>> tracks;

    private static Timeline filterSyncableTracks(Timeline $$0) {
        Map<EnvironmentAttribute<?>, AttributeTrack<?, ?>> $$1 = Map.copyOf(Maps.filterKeys($$0.tracks, EnvironmentAttribute::isSyncable));
        return new Timeline($$0.periodTicks, $$1);
    }

    Timeline(Optional<Integer> $$0, Map<EnvironmentAttribute<?>, AttributeTrack<?, ?>> $$1) {
        this.periodTicks = $$0;
        this.tracks = $$1;
    }

    private static DataResult<Timeline> validateInternal(Timeline $$02) {
        if ($$02.periodTicks.isEmpty()) {
            return DataResult.success((Object)$$02);
        }
        int $$12 = $$02.periodTicks.get();
        DataResult $$2 = DataResult.success((Object)$$02);
        for (AttributeTrack<?, ?> $$3 : $$02.tracks.values()) {
            $$2 = $$2.apply2stable(($$0, $$1) -> $$0, AttributeTrack.validatePeriod($$3, $$12));
        }
        return $$2;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getCurrentTicks(Level $$0) {
        long $$1 = this.getTotalTicks($$0);
        if (this.periodTicks.isEmpty()) {
            return $$1;
        }
        return $$1 % (long)this.periodTicks.get().intValue();
    }

    public long getTotalTicks(Level $$0) {
        return $$0.getDayTime();
    }

    public Optional<Integer> periodTicks() {
        return this.periodTicks;
    }

    public Set<EnvironmentAttribute<?>> attributes() {
        return this.tracks.keySet();
    }

    public <Value> AttributeTrackSampler<Value, ?> createTrackSampler(EnvironmentAttribute<Value> $$0, LongSupplier $$1) {
        AttributeTrack<?, ?> $$2 = this.tracks.get($$0);
        if ($$2 == null) {
            throw new IllegalStateException("Timeline has no track for " + String.valueOf($$0));
        }
        return $$2.bakeSampler($$0, this.periodTicks, $$1);
    }

    public static class Builder {
        private Optional<Integer> periodTicks = Optional.empty();
        private final ImmutableMap.Builder<EnvironmentAttribute<?>, AttributeTrack<?, ?>> tracks = ImmutableMap.builder();

        Builder() {
        }

        public Builder setPeriodTicks(int $$0) {
            this.periodTicks = Optional.of($$0);
            return this;
        }

        public <Value, Argument> Builder addModifierTrack(EnvironmentAttribute<Value> $$0, AttributeModifier<Value, Argument> $$1, Consumer<KeyframeTrack.Builder<Argument>> $$2) {
            $$0.type().checkAllowedModifier($$1);
            KeyframeTrack.Builder $$3 = new KeyframeTrack.Builder();
            $$2.accept($$3);
            this.tracks.put($$0, new AttributeTrack<Value, Argument>($$1, $$3.build()));
            return this;
        }

        public <Value> Builder addTrack(EnvironmentAttribute<Value> $$0, Consumer<KeyframeTrack.Builder<Value>> $$1) {
            return this.addModifierTrack($$0, AttributeModifier.override(), $$1);
        }

        public Timeline build() {
            return new Timeline(this.periodTicks, (Map<EnvironmentAttribute<?>, AttributeTrack<?, ?>>)this.tracks.build());
        }
    }
}

