/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.resources.Identifier;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.event.RegisterNamedRenderTypesEvent;
import net.minecraftforge.eventbus.internal.Event;
import org.jetbrains.annotations.ApiStatus;

public final class NamedRenderTypeManager {
    private static Map<Identifier, RenderTypeGroup> RENDER_TYPES;

    public static RenderTypeGroup get(Identifier name) {
        return RENDER_TYPES.getOrDefault(name, RenderTypeGroup.EMPTY);
    }

    @ApiStatus.Internal
    public static void init() {
        HashMap<Identifier, RenderTypeGroup> renderTypes = new HashMap<Identifier, RenderTypeGroup>();
        NamedRenderTypeManager.preRegisterVanillaRenderTypes(renderTypes);
        RegisterNamedRenderTypesEvent.BUS.post((Event)new RegisterNamedRenderTypesEvent(renderTypes));
        RENDER_TYPES = Map.copyOf(renderTypes);
    }

    private static void preRegisterVanillaRenderTypes(Map<Identifier, RenderTypeGroup> blockRenderTypes) {
        blockRenderTypes.put(NamedRenderTypeManager.rl("solid"), new RenderTypeGroup(ChunkSectionLayer.SOLID, ForgeRenderTypes.ITEM_LAYERED_SOLID.get()));
        blockRenderTypes.put(NamedRenderTypeManager.rl("cutout"), new RenderTypeGroup(ChunkSectionLayer.CUTOUT, ForgeRenderTypes.ITEM_LAYERED_CUTOUT.get()));
        blockRenderTypes.put(NamedRenderTypeManager.rl("translucent_moving_block"), new RenderTypeGroup(ChunkSectionLayer.TRANSLUCENT, ForgeRenderTypes.ITEM_LAYERED_TRANSLUCENT.get()));
        blockRenderTypes.put(NamedRenderTypeManager.rl("tripwire"), new RenderTypeGroup(ChunkSectionLayer.TRIPWIRE, ForgeRenderTypes.ITEM_LAYERED_TRANSLUCENT.get()));
    }

    private static Identifier rl(String path) {
        return Identifier.withDefaultNamespace((String)path);
    }

    private NamedRenderTypeManager() {
    }
}

