/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import java.util.UUID;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.util.Util;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.event.InheritableEvent;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import org.jetbrains.annotations.ApiStatus;

public sealed class ClientChatReceivedEvent
extends MutableEvent
implements Cancellable,
InheritableEvent {
    public static final CancellableEventBus<ClientChatReceivedEvent> BUS = CancellableEventBus.create(ClientChatReceivedEvent.class);
    private Component message;
    private final ChatType.Bound boundChatType;
    private final UUID sender;

    @ApiStatus.Internal
    public ClientChatReceivedEvent(ChatType.Bound boundChatType, Component message, UUID sender) {
        this.boundChatType = boundChatType;
        this.message = message;
        this.sender = sender;
    }

    public Component getMessage() {
        return this.message;
    }

    public void setMessage(Component message) {
        this.message = message;
    }

    public ChatType.Bound getBoundChatType() {
        return this.boundChatType;
    }

    public UUID getSender() {
        return this.sender;
    }

    @Deprecated(forRemoval=true, since="1.21.1")
    public boolean isSystem() {
        return this.sender.equals(Util.NIL_UUID);
    }

    @Deprecated(forRemoval=true, since="1.21.1")
    public static final class System
    extends ClientChatReceivedEvent {
        public static final CancellableEventBus<System> BUS = CancellableEventBus.create(System.class);
        private final boolean overlay;

        @ApiStatus.Internal
        public System(ChatType.Bound boundChatType, Component message, boolean overlay) {
            super(boundChatType, message, Util.NIL_UUID);
            this.overlay = overlay;
        }

        public boolean isOverlay() {
            return this.overlay;
        }
    }

    public static final class Player
    extends ClientChatReceivedEvent {
        public static final CancellableEventBus<Player> BUS = CancellableEventBus.create(Player.class);
        private final PlayerChatMessage playerChatMessage;

        @ApiStatus.Internal
        public Player(ChatType.Bound boundChatType, Component message, PlayerChatMessage playerChatMessage, UUID sender) {
            super(boundChatType, message, sender);
            this.playerChatMessage = playerChatMessage;
        }

        public PlayerChatMessage getPlayerChatMessage() {
            return this.playerChatMessage;
        }
    }
}

