/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import net.minecraftforge.eventbus.api.event.RecordEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;

public sealed interface ModelEvent {

    @NullMarked
    public static final class RegisterGeometryLoaders
    extends MutableEvent
    implements ModelEvent {
        public static final EventBus<RegisterGeometryLoaders> BUS = EventBus.create(RegisterGeometryLoaders.class);
        private final Map<Identifier, IGeometryLoader> loaders;

        @Deprecated(forRemoval=true, since="1.21.9")
        public static EventBus<RegisterGeometryLoaders> getBus(BusGroup modBusGroup) {
            return BUS;
        }

        @ApiStatus.Internal
        public RegisterGeometryLoaders(Map<Identifier, IGeometryLoader> loaders) {
            this.loaders = loaders;
        }

        public void register(Identifier Identifier2, IGeometryLoader loader) {
            Preconditions.checkArgument((!this.loaders.containsKey(Identifier2) ? 1 : 0) != 0, (Object)("Geometry loader already registered: " + String.valueOf(Identifier2)));
            this.loaders.put(Identifier2, loader);
        }
    }

    public static final class RegisterModelStateDefinitions
    extends MutableEvent
    implements ModelEvent {
        public static final EventBus<RegisterModelStateDefinitions> BUS = EventBus.create(RegisterModelStateDefinitions.class);
        private final Map<Identifier, StateDefinition<Block, BlockState>> states = new HashMap<Identifier, StateDefinition<Block, BlockState>>();
        private final Map<Identifier, StateDefinition<Block, BlockState>> view = Collections.unmodifiableMap(this.states);

        @Deprecated(forRemoval=true, since="1.21.9")
        public static EventBus<RegisterModelStateDefinitions> getBus(BusGroup modBusGroup) {
            return BUS;
        }

        @ApiStatus.Internal
        public RegisterModelStateDefinitions() {
        }

        public Map<Identifier, StateDefinition<Block, BlockState>> getStates() {
            return this.view;
        }

        public void register(Identifier key, StateDefinition<Block, BlockState> value) {
            this.states.put(key, value);
        }
    }

    public record BakingCompleted(ModelManager getModelManager, ModelBakery getModelBakery) implements RecordEvent,
    ModelEvent
    {
        public static final EventBus<BakingCompleted> BUS = EventBus.create(BakingCompleted.class);

        @Deprecated(forRemoval=true, since="1.21.9")
        public static EventBus<BakingCompleted> getBus(BusGroup modBusGroup) {
            return BUS;
        }
    }

    public record ModifyBakingResult(ModelBakery getModelBakery, ModelBakery.BakingResult getResults) implements RecordEvent,
    ModelEvent
    {
        public static final EventBus<ModifyBakingResult> BUS = EventBus.create(ModifyBakingResult.class);

        @Deprecated(forRemoval=true, since="1.21.9")
        public static EventBus<ModifyBakingResult> getBus(BusGroup modBusGroup) {
            return BUS;
        }
    }
}

