/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.state.LevelRenderState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.event.InheritableEvent;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract sealed class RenderHighlightEvent
extends MutableEvent
implements Cancellable,
InheritableEvent {
    CancellableEventBus<RenderHighlightEvent> BUS = CancellableEventBus.create(RenderHighlightEvent.class);
    private final LevelRenderer levelRenderer;
    private final Camera camera;
    private final LevelRenderState levelRenderState;
    private Callback customRenderer;

    private RenderHighlightEvent(LevelRenderer levelRenderer, Camera camera, LevelRenderState levelRenderState) {
        this.levelRenderer = levelRenderer;
        this.camera = camera;
        this.levelRenderState = levelRenderState;
    }

    public LevelRenderer getLevelRenderer() {
        return this.levelRenderer;
    }

    public LevelRenderState getLevelRenderState() {
        return this.levelRenderState;
    }

    public Camera getCamera() {
        return this.camera;
    }

    abstract HitResult getTarget();

    @Nullable
    public Callback getCustomRenderer() {
        return this.customRenderer;
    }

    public void setCustomRenderer(@Nullable Callback value) {
        this.customRenderer = value;
    }

    public static interface Callback {
        public void render(MultiBufferSource.BufferSource var1, PoseStack var2, boolean var3, LevelRenderState var4);
    }

    public static final class Entity
    extends RenderHighlightEvent {
        public static final CancellableEventBus<Entity> BUS = CancellableEventBus.create(Entity.class);
        private final EntityHitResult target;

        @ApiStatus.Internal
        public Entity(LevelRenderer levelRenderer, Camera camera, LevelRenderState levelRenderState, EntityHitResult target) {
            super(levelRenderer, camera, levelRenderState);
            this.target = target;
        }

        public EntityHitResult getTarget() {
            return this.target;
        }
    }

    public static final class Block
    extends RenderHighlightEvent {
        public static final CancellableEventBus<Block> BUS = CancellableEventBus.create(Block.class);
        private final BlockHitResult target;

        @ApiStatus.Internal
        public Block(LevelRenderer levelRenderer, Camera camera, LevelRenderState levelRenderState, BlockHitResult target) {
            super(levelRenderer, camera, levelRenderState);
            this.target = target;
        }

        public BlockHitResult getTarget() {
            return this.target;
        }
    }
}

