/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.extensions.common;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ScreenEffectRenderer;
import net.minecraft.client.renderer.fog.FogData;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.FogType;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector4f;

public interface IClientFluidTypeExtensions {
    public static final IClientFluidTypeExtensions DEFAULT = new IClientFluidTypeExtensions(){};

    public static IClientFluidTypeExtensions of(FluidState state) {
        return IClientFluidTypeExtensions.of(state.getFluidType());
    }

    public static IClientFluidTypeExtensions of(Fluid fluid) {
        return IClientFluidTypeExtensions.of(fluid.getFluidType());
    }

    public static IClientFluidTypeExtensions of(FluidType type) {
        IClientFluidTypeExtensions props;
        Object object = type.getRenderPropertiesInternal();
        return object instanceof IClientFluidTypeExtensions ? (props = (IClientFluidTypeExtensions)object) : DEFAULT;
    }

    default public int getTintColor() {
        return -1;
    }

    default public Identifier getStillTexture() {
        return null;
    }

    default public Identifier getFlowingTexture() {
        return null;
    }

    @Nullable
    default public Identifier getOverlayTexture() {
        return null;
    }

    @Nullable
    default public Identifier getRenderOverlayTexture(Minecraft mc) {
        return null;
    }

    default public void renderOverlay(Minecraft mc, PoseStack poseStack, MultiBufferSource buffer) {
        Identifier texture = this.getRenderOverlayTexture(mc);
        if (texture != null) {
            ScreenEffectRenderer.renderFluid((Minecraft)mc, (PoseStack)poseStack, (MultiBufferSource)buffer, (Identifier)texture);
        }
    }

    @NotNull
    default public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
        return fluidFogColor;
    }

    default public void modifyFogRender(Camera camera, FogType type, float partialTick, FogData data, Vector4f color) {
    }

    default public Identifier getStillTexture(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
        return this.getStillTexture();
    }

    default public Identifier getFlowingTexture(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
        return this.getFlowingTexture();
    }

    default public Identifier getOverlayTexture(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
        return this.getOverlayTexture();
    }

    default public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
        return this.getTintColor();
    }

    default public int getTintColor(FluidStack stack) {
        return this.getTintColor();
    }

    default public Identifier getStillTexture(FluidStack stack) {
        return this.getStillTexture();
    }

    default public Identifier getFlowingTexture(FluidStack stack) {
        return this.getFlowingTexture();
    }

    default public Identifier getOverlayTexture(FluidStack stack) {
        return this.getOverlayTexture();
    }
}

