/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.gui.overlay;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.Identifier;
import net.minecraftforge.client.event.ForgeEventFactoryClient;
import net.minecraftforge.client.gui.overlay.ForgeLayer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class ForgeLayeredDraw
implements ForgeLayer {
    private final Map<Identifier, ForgeLayer> namedLayers = new HashMap<Identifier, ForgeLayer>();
    private final Map<Identifier, Map.Entry<ForgeLayeredDraw, BooleanSupplier>> subLayerStacks = new HashMap<Identifier, Map.Entry<ForgeLayeredDraw, BooleanSupplier>>();
    private final List<Identifier> order = new LinkedList<Identifier>();
    private final List<ForgeLayer> bakedLayers = new ArrayList<ForgeLayer>();
    private final Identifier name;
    public static final Identifier PRE_SLEEP_STACK = Identifier.withDefaultNamespace((String)"pre_sleep_phase");
    public static final Identifier CAMERA_OVERLAY = Identifier.withDefaultNamespace((String)"camera_overlay");
    public static final Identifier CROSSHAIR = Identifier.withDefaultNamespace((String)"crosshair");
    public static final Identifier CHANGE_STRATUM = Identifier.withDefaultNamespace((String)"stratum_change");
    public static final Identifier HOTBAR_AND_DECOS = Identifier.withDefaultNamespace((String)"hotbar");
    public static final Identifier POTION_EFFECTS = Identifier.withDefaultNamespace((String)"potion_effects");
    public static final Identifier BOSS_OVERLAY = Identifier.withDefaultNamespace((String)"boss_overlay");
    public static final Identifier POST_SLEEP_STACK = Identifier.withDefaultNamespace((String)"post_sleep_phase");
    public static final Identifier DEMO_OVERLAY = Identifier.withDefaultNamespace((String)"demo");
    public static final Identifier DEBUG_OVERLAY = Identifier.withDefaultNamespace((String)"debug");
    public static final Identifier SCOREBOARD = Identifier.withDefaultNamespace((String)"scoreboard");
    public static final Identifier HOTBAR_MESSAGE = Identifier.withDefaultNamespace((String)"hotbar_message");
    public static final Identifier TITLE_OVERLAY = Identifier.withDefaultNamespace((String)"title");
    public static final Identifier CHAT_OVERLAY = Identifier.withDefaultNamespace((String)"chat_overlay");
    public static final Identifier TAB_LIST = Identifier.withDefaultNamespace((String)"tab_list");
    public static final Identifier SUBTITLE_OVERLAY = Identifier.withDefaultNamespace((String)"subtitle");
    public static final Identifier VANILLA_ROOT = Identifier.withDefaultNamespace((String)"vanilla_root");
    public static final Identifier SLEEP_OVERLAY = Identifier.withDefaultNamespace((String)"sleep_overlay");
    private static final ForgeLayeredDraw instance = new ForgeLayeredDraw(VANILLA_ROOT);

    public ForgeLayeredDraw(Identifier name) {
        this.name = name;
    }

    public ForgeLayeredDraw add(Identifier name, ForgeLayeredDraw layeredDraw, BooleanSupplier supplier) {
        if (this.isNameAvailable(name)) {
            this.subLayerStacks.put(name, Map.entry(layeredDraw, supplier));
            this.order.add(name);
        } else {
            this.nameTakenWarning(name);
        }
        return this;
    }

    public ForgeLayeredDraw add(Identifier targetStack, Identifier name, ForgeLayer layer) {
        this.locateStack(targetStack).ifPresentOrElse(stack -> stack.add(name, layer), () -> this.stackNotPresentWarning(targetStack));
        return this;
    }

    public ForgeLayeredDraw add(Identifier name, ForgeLayer layer) {
        if (this.isNameAvailable(name)) {
            this.namedLayers.put(name, layer);
            this.order.add(name);
        } else {
            this.nameTakenWarning(name);
        }
        return this;
    }

    public ForgeLayeredDraw putAbove(Identifier expectedStack, Identifier target, Identifier destination) {
        this.locateStack(expectedStack).ifPresentOrElse(stack -> stack.move(target, destination, LayerOffset.ABOVE), () -> this.stackNotPresentWarning(expectedStack));
        return this;
    }

    public ForgeLayeredDraw putBelow(Identifier expectedStack, Identifier target, Identifier destination) {
        this.locateStack(expectedStack).ifPresentOrElse(stack -> stack.move(target, destination, LayerOffset.BELOW), () -> this.stackNotPresentWarning(expectedStack));
        return this;
    }

    public ForgeLayeredDraw move(Identifier target, Identifier destination, LayerOffset offset) {
        if (!this.order.contains(target)) {
            this.layerNotPresentWarning(target);
            return this;
        }
        int loc = this.order.indexOf(destination);
        if (loc == -1) {
            this.layerNotPresentWarning(destination);
            return this;
        }
        this.order.remove(target);
        this.order.add(loc + (offset == LayerOffset.ABOVE ? 1 : 0), target);
        return this;
    }

    public ForgeLayeredDraw addAbove(Identifier expectedStack, Identifier newLayer, Identifier otherLayer, ForgeLayer layer) {
        this.locateStack(expectedStack).ifPresentOrElse(stack -> {
            if (!stack.isNameAvailable(otherLayer)) {
                stack.add(newLayer, layer).move(newLayer, otherLayer, LayerOffset.ABOVE);
            } else {
                this.layerNotPresentWarning(otherLayer);
            }
        }, () -> this.stackNotPresentWarning(expectedStack));
        return this;
    }

    public ForgeLayeredDraw addAbove(Identifier newLayer, Identifier otherLayer, ForgeLayer layer) {
        return this.addAbove(this.name, newLayer, otherLayer, layer);
    }

    public ForgeLayeredDraw addBelow(Identifier expectedStack, Identifier newLayer, Identifier otherLayer, ForgeLayer layer) {
        this.locateStack(expectedStack).ifPresentOrElse(stack -> {
            if (!stack.isNameAvailable(otherLayer)) {
                stack.add(newLayer, layer).move(newLayer, otherLayer, LayerOffset.BELOW);
            } else {
                this.layerNotPresentWarning(otherLayer);
            }
        }, () -> this.stackNotPresentWarning(expectedStack));
        return this;
    }

    public ForgeLayeredDraw addBelow(Identifier newLayer, Identifier otherLayer, ForgeLayer layer) {
        return this.addBelow(this.name, newLayer, otherLayer, layer);
    }

    public ForgeLayeredDraw addWithCondition(Identifier targetStack, Identifier name, ForgeLayer layer, BooleanSupplier condition) {
        this.locateStack(targetStack).ifPresentOrElse(stack -> stack.addWithCondition(name, layer, condition), () -> this.stackNotPresentWarning(targetStack));
        return this;
    }

    public ForgeLayeredDraw addWithCondition(Identifier name, ForgeLayer layer, BooleanSupplier condition) {
        this.add(name, layer).addConditionTo(name, condition);
        return this;
    }

    public ForgeLayeredDraw addConditionTo(Identifier targetStack, Identifier targetLayer, BooleanSupplier condition) {
        this.locateStack(targetStack).ifPresentOrElse(stack -> stack.addConditionTo(targetLayer, condition), () -> this.stackNotPresentWarning(targetStack));
        return this;
    }

    public ForgeLayeredDraw addConditionTo(Identifier targetLayer, BooleanSupplier condition) {
        ForgeLayer result = this.namedLayers.computeIfPresent(targetLayer, (name, layer) -> (guiGraphics, deltaTracker) -> {
            if (condition.getAsBoolean()) {
                layer.render(guiGraphics, deltaTracker);
            }
        });
        if (result == null) {
            this.layerNotPresentWarning(targetLayer);
        }
        return this;
    }

    @ApiStatus.Internal
    public ForgeLayeredDraw resolveLayers() {
        if (!this.order.isEmpty()) {
            ForgeEventFactoryClient.onComputeLayerOrder(this);
        }
        this.resolveNested();
        this.order.clear();
        return this;
    }

    private void resolveNested() {
        for (Identifier layerName : this.order) {
            if (this.subLayerStacks.containsKey(layerName)) {
                Map.Entry<ForgeLayeredDraw, BooleanSupplier> entry = this.subLayerStacks.get(layerName);
                entry.getKey().resolveNested();
                this.bakedLayers.add((gg, tr) -> {
                    if (((BooleanSupplier)entry.getValue()).getAsBoolean()) {
                        ((ForgeLayeredDraw)entry.getKey()).render(gg, tr);
                    }
                });
                continue;
            }
            this.bakedLayers.add(this.namedLayers.get(layerName));
        }
    }

    public Optional<ForgeLayeredDraw> locateStack(Identifier targetStack) {
        if (!this.name.equals((Object)targetStack)) {
            for (Map.Entry<ForgeLayeredDraw, BooleanSupplier> value : this.subLayerStacks.values()) {
                ForgeLayeredDraw searchable;
                Optional<ForgeLayeredDraw> res;
                ForgeLayeredDraw forgeLayeredDraw = value.getKey();
                if (!(forgeLayeredDraw instanceof ForgeLayeredDraw) || !(res = (searchable = forgeLayeredDraw).locateStack(targetStack)).isPresent()) continue;
                return res;
            }
            return Optional.empty();
        }
        return Optional.of(this);
    }

    @Nullable
    public ForgeLayeredDraw getChild(Identifier childName) {
        return this.locateStack(childName).orElse(null);
    }

    @Nullable
    public ForgeLayer getLayer(Identifier layerName) {
        return this.namedLayers.get(layerName);
    }

    public Identifier getName() {
        return this.name;
    }

    private void stackNotPresentWarning(Identifier stackName) {
        LogUtils.getLogger().warn("Target stack {} was not present anywhere. Is your Identifier correct?", (Object)stackName);
    }

    private void layerNotPresentWarning(Identifier layer) {
        LogUtils.getLogger().warn("Expected layer {} was not found in stack {}, no layer modifications have been made.", (Object)layer, (Object)this.name);
    }

    private void nameTakenWarning(Identifier layer) {
        LogUtils.getLogger().warn("Name {} was already present in {} and cannot be re-used.", (Object)layer, (Object)this.name);
    }

    private boolean isNameAvailable(Identifier name) {
        return !this.namedLayers.containsKey(name) && !this.subLayerStacks.containsKey(name);
    }

    @ApiStatus.Internal
    public static void beginRender(GuiGraphics gg, DeltaTracker dt) {
        instance.render(gg, dt);
    }

    @Override
    @ApiStatus.Internal
    public void render(GuiGraphics gg, DeltaTracker dt) {
        for (ForgeLayer bakedLayer : this.bakedLayers) {
            bakedLayer.render(gg, dt);
        }
    }

    @ApiStatus.Internal
    public static void init(Gui gui, Minecraft minecraft) {
        ForgeLayeredDraw preSleepDraw = new ForgeLayeredDraw(PRE_SLEEP_STACK).add(CAMERA_OVERLAY, (arg_0, arg_1) -> ((Gui)gui).renderCameraOverlays(arg_0, arg_1)).add(CROSSHAIR, (arg_0, arg_1) -> ((Gui)gui).renderCrosshair(arg_0, arg_1)).add(CHANGE_STRATUM, (gg, dt) -> gg.nextStratum()).add(HOTBAR_AND_DECOS, (arg_0, arg_1) -> ((Gui)gui).renderHotbarAndDecorations(arg_0, arg_1)).add(POTION_EFFECTS, (arg_0, arg_1) -> ((Gui)gui).renderEffects(arg_0, arg_1)).add(BOSS_OVERLAY, (arg_0, arg_1) -> ((Gui)gui).renderBossOverlay(arg_0, arg_1));
        ForgeLayeredDraw postSleepDraw = new ForgeLayeredDraw(POST_SLEEP_STACK).add(DEMO_OVERLAY, (arg_0, arg_1) -> ((Gui)gui).renderDemoOverlay(arg_0, arg_1)).add(SCOREBOARD, (arg_0, arg_1) -> ((Gui)gui).renderScoreboardSidebar(arg_0, arg_1)).add(HOTBAR_MESSAGE, (arg_0, arg_1) -> ((Gui)gui).renderOverlayMessage(arg_0, arg_1)).add(TITLE_OVERLAY, (arg_0, arg_1) -> ((Gui)gui).renderTitle(arg_0, arg_1)).add(CHAT_OVERLAY, (arg_0, arg_1) -> ((Gui)gui).renderChat(arg_0, arg_1)).add(TAB_LIST, (arg_0, arg_1) -> ((Gui)gui).renderTabList(arg_0, arg_1)).add(SUBTITLE_OVERLAY, (gfx, delta) -> gui.renderSubtitleOverlay(gfx, minecraft.screen != null && minecraft.screen.isInGameUi()));
        instance.add(PRE_SLEEP_STACK, preSleepDraw, () -> !minecraft.options.hideGui).add(SLEEP_OVERLAY, (arg_0, arg_1) -> ((Gui)gui).renderSleepOverlay(arg_0, arg_1)).add(POST_SLEEP_STACK, postSleepDraw, () -> !minecraft.options.hideGui).add(SUBTITLE_OVERLAY, (gfx, delta) -> {
            if (minecraft.options.hideGui && minecraft.screen != null && minecraft.screen.isInGameUi()) {
                gui.renderSubtitleOverlay(gfx, true);
            }
        });
        instance.resolveLayers();
    }

    public static enum LayerOffset {
        ABOVE,
        BELOW;

    }
}

