/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.listener.EventListener;

public class WorldWorkerManager {
    private static final ArrayList<IWorker> workers = new ArrayList();
    private static long startTime = -1L;
    private static int index = 0;
    private static EventListener tickStartListener;
    private static EventListener tickEndListener;

    private static void startTick() {
        startTime = System.currentTimeMillis();
    }

    private static void endTick() {
        index = 0;
        IWorker task = WorldWorkerManager.getNext();
        if (task == null) {
            WorldWorkerManager.clear();
            return;
        }
        long time = 50L - (System.currentTimeMillis() - startTime);
        if (time < 10L) {
            time = 10L;
        }
        time += System.currentTimeMillis();
        while (System.currentTimeMillis() < time && task != null) {
            boolean again = task.doWork();
            if (!task.hasWork()) {
                WorldWorkerManager.remove(task);
                task = WorldWorkerManager.getNext();
                continue;
            }
            if (again) continue;
            task = WorldWorkerManager.getNext();
        }
    }

    @Deprecated(forRemoval=true, since="1.21.8")
    public static void tick(boolean start) {
        if (start) {
            WorldWorkerManager.startTick();
        } else {
            WorldWorkerManager.endTick();
        }
    }

    public static synchronized void addWorker(IWorker worker) {
        workers.add(worker);
        if (tickStartListener == null) {
            tickStartListener = TickEvent.ServerTickEvent.Pre.BUS.addListener(event -> WorldWorkerManager.startTick());
            tickEndListener = TickEvent.ServerTickEvent.Post.BUS.addListener(event -> WorldWorkerManager.endTick());
        }
    }

    private static synchronized IWorker getNext() {
        return workers.size() > index ? workers.get(index++) : null;
    }

    private static synchronized void remove(IWorker worker) {
        workers.remove(worker);
        --index;
    }

    public static synchronized void clear() {
        workers.clear();
        if (tickStartListener != null) {
            TickEvent.ServerTickEvent.Pre.BUS.removeListener(tickStartListener);
            TickEvent.ServerTickEvent.Post.BUS.removeListener(tickEndListener);
            tickStartListener = null;
            tickEndListener = null;
        }
    }

    public static interface IWorker {
        public boolean hasWork();

        public boolean doWork();
    }
}

