/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting.conditions;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.DelegatingOps;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class ConditionCodec {
    public static <T> Codec<T> checkingDecode(Codec<T> normal, Supplier<T> _default) {
        return ConditionCodec.checkingDecode(normal, _default, "forge:condition");
    }

    public static <T> Codec<T> checkingDecode(Codec<T> normal, Supplier<T> _default, String key) {
        return Codec.of(normal, new UnwrapDecoder<T>(ConditionCodec.wrap(normal, key), _default));
    }

    public static <T> Decoder<Optional<T>> wrap(Decoder<T> normal) {
        return ConditionCodec.wrap(normal, "forge:condition");
    }

    public static <T> Decoder<Optional<T>> wrap(Decoder<T> normal, String key) {
        return new OptionalConditionalDecoder<T>(normal, key);
    }

    public static <T> ICondition.IContext getContext(DynamicOps<T> ops) {
        ICondition.IContext ret = null;
        if (ops instanceof DelegatingOps) {
            DelegatingOps dele = (DelegatingOps)ops;
            ret = (ICondition.IContext)dele.getContext(ICondition.IContext.KEY);
        }
        return ret == null ? ICondition.IContext.EMPTY : ret;
    }

    private record UnwrapDecoder<A>(Decoder<Optional<A>> normal, Supplier<A> _default) implements Decoder<A>
    {
        public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
            DataResult ret = this.normal.decode(ops, input);
            if (!ret.result().isPresent() || !((Optional)((Pair)ret.result().get()).getFirst()).isPresent()) {
                return ret.map(p -> p.mapFirst(e -> this._default.get()));
            }
            return ret.map(p -> p.mapFirst(Optional::get));
        }
    }

    private record OptionalConditionalDecoder<A>(Decoder<A> normal, String key) implements Decoder<Optional<A>>
    {
        public <T> DataResult<Pair<Optional<A>, T>> decode(DynamicOps<T> ops, T input) {
            DataResult conditionRaw = ops.get(input, this.key);
            if (conditionRaw.error().isPresent() || !conditionRaw.result().isPresent()) {
                return this.normal.decode(ops, input).map(p -> p.mapFirst(Optional::of));
            }
            DataResult conditionDecoded = ICondition.CODEC.parse(ops, conditionRaw.result().get());
            if (conditionDecoded.error().isPresent()) {
                return DataResult.error(() -> ((DataResult.Error)conditionDecoded.error().get()).message());
            }
            ICondition condition = (ICondition)conditionDecoded.result().get();
            if (!condition.test(ConditionCodec.getContext(ops), ops)) {
                return DataResult.success((Object)Pair.of(Optional.empty(), (Object)ops.empty()));
            }
            return this.normal.decode(ops, input).map(p -> p.mapFirst(Optional::of));
        }
    }
}

