/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting.conditions;

import java.util.List;
import net.minecraft.resources.Identifier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.crafting.conditions.AndCondition;
import net.minecraftforge.common.crafting.conditions.FalseCondition;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ItemExistsCondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.OrCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.common.crafting.conditions.TrueCondition;

public interface IConditionBuilder {
    default public ICondition and(ICondition ... values) {
        return new AndCondition(List.of(values));
    }

    default public ICondition FALSE() {
        return FalseCondition.INSTANCE;
    }

    default public ICondition TRUE() {
        return TrueCondition.INSTANCE;
    }

    default public ICondition not(ICondition value) {
        return new NotCondition(value);
    }

    default public ICondition or(ICondition ... values) {
        return new OrCondition(List.of(values));
    }

    default public ICondition itemExists(String namespace, String path) {
        return new ItemExistsCondition(Identifier.fromNamespaceAndPath((String)namespace, (String)path));
    }

    default public ICondition modLoaded(String modid) {
        return new ModLoadedCondition(modid);
    }

    default public ICondition tagEmpty(TagKey<Item> tag) {
        return new TagEmptyCondition(tag);
    }
}

