/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting.ingredients;

import java.util.Arrays;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.ingredients.CompoundIngredient;
import net.minecraftforge.common.crafting.ingredients.DifferenceIngredient;
import net.minecraftforge.common.crafting.ingredients.IntersectionIngredient;
import net.minecraftforge.common.crafting.ingredients.PartialNBTIngredient;
import net.minecraftforge.common.crafting.ingredients.StrictNBTIngredient;

public interface IIngredientBuilder {
    default public PartialNBTIngredient.Builder partialNbt() {
        return PartialNBTIngredient.builder();
    }

    default public Ingredient strictNbt(ItemStack value) {
        return StrictNBTIngredient.of(value);
    }

    default public Ingredient compound(Ingredient ... values) {
        return CompoundIngredient.of(values);
    }

    default public Ingredient intersection(HolderGetter<Item> lookup, TagKey ... values) {
        return this.intersection((Ingredient[])Arrays.stream(values).map(k -> IIngredientBuilder.holder(lookup, (TagKey<Item>)k)).map(Ingredient::of).toArray(Ingredient[]::new));
    }

    default public Ingredient intersection(Ingredient ... values) {
        return IntersectionIngredient.of(values);
    }

    default public Ingredient difference(HolderGetter<Item> lookup, TagKey<Item> base, TagKey<Item> subtracted) {
        return this.difference(Ingredient.of(IIngredientBuilder.holder(lookup, base)), Ingredient.of(IIngredientBuilder.holder(lookup, subtracted)));
    }

    default public Ingredient difference(Ingredient base, Ingredient subtracted) {
        return DifferenceIngredient.of(base, subtracted);
    }

    private static HolderSet<Item> holder(HolderGetter<Item> lookup, TagKey<Item> key) {
        return lookup.getOrThrow(key);
    }
}

