/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting.ingredients;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.advancements.criterion.NbtPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.ingredients.AbstractIngredient;
import net.minecraftforge.common.crafting.ingredients.IIngredientSerializer;
import org.jetbrains.annotations.Nullable;

public class PartialNBTIngredient
extends AbstractIngredient {
    private final CompoundTag nbt;
    private final NbtPredicate predicate;
    public static final MapCodec<PartialNBTIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.NON_AIR_HOLDER_SET_CODEC.fieldOf("items").forGetter(i -> i.values), (App)TagParser.FLATTENED_CODEC.fieldOf("nbt").forGetter(i -> i.nbt)).apply((Applicative)builder, PartialNBTIngredient::new));
    public static final IIngredientSerializer<PartialNBTIngredient> SERIALIZER = new IIngredientSerializer<PartialNBTIngredient>(){
        private final StreamCodec<RegistryFriendlyByteBuf, HolderSet<Item>> HOLDER_SET = ByteBufCodecs.holderSet((ResourceKey)Registries.ITEM);

        @Override
        public MapCodec<? extends PartialNBTIngredient> codec() {
            return CODEC;
        }

        @Override
        public PartialNBTIngredient read(RegistryFriendlyByteBuf buffer) {
            HolderSet items = (HolderSet)this.HOLDER_SET.decode((Object)buffer);
            CompoundTag nbt = buffer.readNbt();
            return new PartialNBTIngredient((HolderSet<Item>)items, Objects.requireNonNull(nbt));
        }

        @Override
        public void write(RegistryFriendlyByteBuf buffer, PartialNBTIngredient value) {
            this.HOLDER_SET.encode((Object)buffer, (Object)value.values);
            buffer.writeNbt((Tag)value.nbt);
        }
    };

    public static Builder builder() {
        return new Builder();
    }

    private PartialNBTIngredient(HolderSet<Item> items, CompoundTag nbt) {
        super(items);
        if (items.size() == 0) {
            throw new IllegalArgumentException("Cannot create a PartialNBTIngredient with no items");
        }
        this.nbt = nbt;
        this.predicate = new NbtPredicate(nbt);
    }

    public static PartialNBTIngredient of(CompoundTag nbt, ItemLike ... items) {
        return PartialNBTIngredient.of((HolderSet<Item>)HolderSet.direct(Arrays.stream(items).map(ItemLike::asItem).map(Item::builtInRegistryHolder).toList()), nbt);
    }

    public static PartialNBTIngredient of(ItemLike item, CompoundTag nbt) {
        return PartialNBTIngredient.of((HolderSet<Item>)HolderSet.direct((Holder[])new Holder[]{item.asItem().builtInRegistryHolder()}), nbt);
    }

    public static PartialNBTIngredient of(HolderSet<Item> items, CompoundTag nbt) {
        return new PartialNBTIngredient(items, nbt);
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        CustomData nbt = (CustomData)input.get(DataComponents.CUSTOM_DATA);
        return nbt != null && input.is(this.values) && this.predicate.matches((Tag)nbt.copyTag());
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public IIngredientSerializer<? extends Ingredient> serializer() {
        return SERIALIZER;
    }

    public static class Builder {
        private final List<ItemLike> items = new ArrayList<ItemLike>();
        private CompoundTag nbt;

        public Builder nbt(CompoundTag value) {
            if (this.nbt != null) {
                throw new IllegalStateException("NBT Tag already set");
            }
            this.nbt = value;
            return this;
        }

        public Builder item(ItemLike item) {
            this.items.add(item);
            return this;
        }

        public Builder items(ItemLike ... values) {
            for (ItemLike item : values) {
                this.items.add(item);
            }
            return this;
        }

        public PartialNBTIngredient build() {
            if (this.nbt == null) {
                throw new IllegalStateException("NBT Data not set");
            }
            if (this.items.isEmpty()) {
                throw new IllegalStateException("No items added");
            }
            return PartialNBTIngredient.of(this.nbt, (ItemLike[])this.items.stream().toArray(ItemLike[]::new));
        }
    }
}

