/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.RegistryOps;
import net.minecraftforge.common.loot.IGlobalLootModifier;

public abstract class GlobalLootModifierProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final PackOutput output;
    private final String modid;
    private final CompletableFuture<HolderLookup.Provider> registries;
    private final Map<String, IGlobalLootModifier> toSerialize = new HashMap<String, IGlobalLootModifier>();
    private boolean replace = false;

    public GlobalLootModifierProvider(PackOutput output, String modid, CompletableFuture<HolderLookup.Provider> registries) {
        this.output = output;
        this.modid = modid;
        this.registries = registries;
    }

    protected void replacing() {
        this.replace = true;
    }

    protected abstract void start(HolderLookup.Provider var1);

    public CompletableFuture<?> run(CachedOutput cache) {
        return this.registries.thenCompose(p -> this.run(cache, (HolderLookup.Provider)p));
    }

    private CompletableFuture<?> run(CachedOutput cache, HolderLookup.Provider registries) {
        this.start(registries);
        Path forgePath = this.output.getOutputFolder(PackOutput.Target.DATA_PACK).resolve("forge/loot_modifiers/global_loot_modifiers.json");
        Path modifierFolderPath = this.output.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(this.modid).resolve("loot_modifiers");
        ArrayList entries = new ArrayList();
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        RegistryOps ops = registries.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        Codec<IGlobalLootModifier> codec = IGlobalLootModifier.DIRECT_CODEC;
        this.toSerialize.forEach(LamdbaExceptionUtils.rethrowBiConsumer((name, instance) -> {
            JsonElement json = (JsonElement)codec.encodeStart((DynamicOps)ops, instance).getOrThrow();
            entries.add(Identifier.fromNamespaceAndPath((String)this.modid, (String)name));
            Path modifierPath = modifierFolderPath.resolve(name + ".json");
            futuresBuilder.add((Object)DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)modifierPath));
        }));
        JsonObject forgeJson = new JsonObject();
        forgeJson.addProperty("replace", Boolean.valueOf(this.replace));
        forgeJson.add("entries", GSON.toJsonTree(entries.stream().map(Identifier::toString).collect(Collectors.toList())));
        futuresBuilder.add((Object)DataProvider.saveStable((CachedOutput)cache, (JsonElement)forgeJson, (Path)forgePath));
        return CompletableFuture.allOf((CompletableFuture[])futuresBuilder.build().toArray(CompletableFuture[]::new));
    }

    public <T extends IGlobalLootModifier> void add(String modifier, T instance) {
        this.toSerialize.put(modifier, instance);
    }

    public String getName() {
        return "Global Loot Modifiers : " + this.modid;
    }
}

