/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSources;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;

public abstract class SpriteSourceProvider
extends JsonCodecProvider<List<SpriteSource>> {
    protected static final Identifier BLOCKS_ATLAS = Identifier.withDefaultNamespace((String)"blocks");
    protected static final Identifier BANNER_PATTERNS_ATLAS = Identifier.withDefaultNamespace((String)"banner_patterns");
    protected static final Identifier BEDS_ATLAS = Identifier.withDefaultNamespace((String)"beds");
    protected static final Identifier CHESTS_ATLAS = Identifier.withDefaultNamespace((String)"chests");
    protected static final Identifier SHIELD_PATTERNS_ATLAS = Identifier.withDefaultNamespace((String)"shield_patterns");
    protected static final Identifier SHULKER_BOXES_ATLAS = Identifier.withDefaultNamespace((String)"shulker_boxes");
    protected static final Identifier SIGNS_ATLAS = Identifier.withDefaultNamespace((String)"signs");
    protected static final Identifier MOB_EFFECTS_ATLAS = Identifier.withDefaultNamespace((String)"mob_effects");
    protected static final Identifier PAINTINGS_ATLAS = Identifier.withDefaultNamespace((String)"paintings");
    protected static final Identifier PARTICLES_ATLAS = Identifier.withDefaultNamespace((String)"particles");
    private final Map<Identifier, SourceList> atlases = new HashMap<Identifier, SourceList>();

    public SpriteSourceProvider(PackOutput output, ExistingFileHelper fileHelper, String modid) {
        super(output, fileHelper, modid, (DynamicOps<JsonElement>)JsonOps.INSTANCE, PackType.CLIENT_RESOURCES, "atlases", SpriteSources.FILE_CODEC, Map.of());
    }

    @Override
    protected final void gather(BiConsumer<Identifier, List<SpriteSource>> consumer) {
        this.addSources();
        for (Map.Entry<Identifier, SourceList> entry : this.atlases.entrySet()) {
            Identifier atlas = entry.getKey();
            SourceList srcList = entry.getValue();
            consumer.accept(atlas, srcList.sources);
        }
    }

    protected abstract void addSources();

    protected final SourceList atlas(Identifier atlas) {
        return this.atlases.computeIfAbsent(atlas, $ -> new SourceList());
    }

    protected static final class SourceList {
        private final List<SpriteSource> sources = new ArrayList<SpriteSource>();

        protected SourceList() {
        }

        public SourceList addSource(SpriteSource source) {
            this.sources.add(source);
            return this;
        }
    }
}

