/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import net.minecraft.data.tags.TagAppender;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagKey;

public interface IForgeTagAppender<E, T> {
    private TagAppender<E, T> self() {
        return (TagAppender)this;
    }

    default public TagBuilder getInternalBuilder() {
        throw new IllegalStateException("Could not determine internal tag builder");
    }

    default public String getSourceName() {
        return "unknown";
    }

    default public TagAppender<E, T> remove(E entry) {
        throw new UnsupportedOperationException("TagAppender.remove is not implemented in class: " + String.valueOf(this.getClass()));
    }

    default public TagAppender<E, T> remove(E first, E ... entries) {
        this.remove(first);
        for (E entry : entries) {
            this.remove(entry);
        }
        return this.self();
    }

    default public TagAppender<E, T> addTags(TagKey<T> ... values) {
        TagAppender<E, T> builder = this.self();
        for (TagKey<T> value : values) {
            builder.addTag(value);
        }
        return builder;
    }

    default public TagAppender<E, T> addOptional(Identifier location) {
        this.self().getInternalBuilder().addOptionalElement(location);
        return this.self();
    }

    default public TagAppender<E, T> addOptionalTags(TagKey<T> ... values) {
        TagAppender<E, T> builder = this.self();
        for (TagKey<T> value : values) {
            builder.addOptionalTag(value);
        }
        return builder;
    }

    default public TagAppender<E, T> replace() {
        return this.replace(true);
    }

    default public TagAppender<E, T> replace(boolean value) {
        this.self().getInternalBuilder().replace(value);
        return this.self();
    }

    default public TagAppender<E, T> remove(Identifier location) {
        TagAppender<E, T> builder = this.self();
        builder.getInternalBuilder().removeElement(location, builder.getSourceName());
        return builder;
    }

    default public TagAppender<E, T> remove(Identifier first, Identifier ... locations) {
        this.remove(first);
        for (Identifier location : locations) {
            this.remove(location);
        }
        return this.self();
    }

    default public TagAppender<E, T> remove(ResourceKey<T> resourceKey) {
        this.remove(resourceKey.identifier());
        return this.self();
    }

    default public TagAppender<E, T> remove(TagKey<T> tag) {
        TagAppender<E, T> builder = this.self();
        builder.getInternalBuilder().removeTag(tag.location(), builder.getSourceName());
        return builder;
    }

    default public TagAppender<E, T> remove(TagKey<T> first, TagKey<T> ... tags) {
        this.remove(first);
        for (TagKey<T> tag : tags) {
            this.remove(tag);
        }
        return this.self();
    }
}

