/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.living;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import net.minecraftforge.eventbus.api.event.RecordEvent;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import org.jetbrains.annotations.Nullable;

public interface LivingEvent
extends EntityEvent {
    public LivingEntity getEntity();

    public static final class LivingVisibilityEvent
    extends MutableEvent
    implements LivingEvent {
        public static final EventBus<LivingVisibilityEvent> BUS = EventBus.create(LivingVisibilityEvent.class);
        private final LivingEntity livingEntity;
        private double visibilityModifier;
        @Nullable
        private final Entity lookingEntity;

        public LivingVisibilityEvent(LivingEntity livingEntity, @Nullable Entity lookingEntity, double originalMultiplier) {
            this.livingEntity = livingEntity;
            this.visibilityModifier = originalMultiplier;
            this.lookingEntity = lookingEntity;
        }

        @Override
        public LivingEntity getEntity() {
            return this.livingEntity;
        }

        public void modifyVisibility(double mod) {
            this.visibilityModifier *= mod;
        }

        public double getVisibilityModifier() {
            return this.visibilityModifier;
        }

        @Nullable
        public Entity getLookingEntity() {
            return this.lookingEntity;
        }
    }

    public static final class LivingJumpEvent
    extends Record
    implements LivingEvent,
    RecordEvent {
        private final LivingEntity getEntity;
        public static final EventBus<LivingJumpEvent> BUS = EventBus.create(LivingJumpEvent.class);

        public LivingJumpEvent(LivingEntity getEntity) {
            this.getEntity = getEntity;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{LivingJumpEvent.class, "getEntity", "getEntity"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LivingJumpEvent.class, "getEntity", "getEntity"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LivingJumpEvent.class, "getEntity", "getEntity"}, this, o);
        }

        @Override
        public LivingEntity getEntity() {
            return this.getEntity;
        }
    }

    public static final class LivingTickEvent
    extends Record
    implements Cancellable,
    LivingEvent,
    RecordEvent {
        private final LivingEntity getEntity;
        public static final CancellableEventBus<LivingTickEvent> BUS = CancellableEventBus.create(LivingTickEvent.class);

        public LivingTickEvent(LivingEntity getEntity) {
            this.getEntity = getEntity;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{LivingTickEvent.class, "getEntity", "getEntity"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LivingTickEvent.class, "getEntity", "getEntity"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LivingTickEvent.class, "getEntity", "getEntity"}, this, o);
        }

        @Override
        public LivingEntity getEntity() {
            return this.getEntity;
        }
    }
}

