/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items.wrapper;

import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class InvWrapper
implements IItemHandlerModifiable {
    private final Container inv;

    public InvWrapper(Container inv) {
        this.inv = inv;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvWrapper that = (InvWrapper)o;
        return this.getInv().equals((Object)that.getInv());
    }

    public int hashCode() {
        return this.getInv().hashCode();
    }

    @Override
    public int getSlots() {
        return this.getInv().getContainerSize();
    }

    @Override
    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.getInv().getItem(slot);
    }

    @Override
    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.getInv().getItem(slot);
        if (!stackInSlot.isEmpty()) {
            if (stackInSlot.getCount() >= Math.min(stackInSlot.getMaxStackSize(), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemHandlerHelper.canItemStacksStack(stack, stackInSlot)) {
                return stack;
            }
            if (!this.getInv().canPlaceItem(slot, stack)) {
                return stack;
            }
            int m = Math.min(stack.getMaxStackSize(), this.getSlotLimit(slot)) - stackInSlot.getCount();
            if (stack.getCount() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.copy();
                    copy.grow(stackInSlot.getCount());
                    this.getInv().setItem(slot, copy);
                    this.getInv().setChanged();
                }
                return ItemStack.EMPTY;
            }
            stack = stack.copy();
            if (!simulate) {
                ItemStack copy = stack.split(m);
                copy.grow(stackInSlot.getCount());
                this.getInv().setItem(slot, copy);
                this.getInv().setChanged();
                return stack;
            }
            stack.shrink(m);
            return stack;
        }
        if (!this.getInv().canPlaceItem(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.getMaxStackSize(), this.getSlotLimit(slot));
        if (m < stack.getCount()) {
            stack = stack.copy();
            if (!simulate) {
                this.getInv().setItem(slot, stack.split(m));
                this.getInv().setChanged();
                return stack;
            }
            stack.shrink(m);
            return stack;
        }
        if (!simulate) {
            this.getInv().setItem(slot, stack);
            this.getInv().setChanged();
        }
        return ItemStack.EMPTY;
    }

    @Override
    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.getInv().getItem(slot);
        if (stackInSlot.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (simulate) {
            if (stackInSlot.getCount() < amount) {
                return stackInSlot.copy();
            }
            ItemStack copy = stackInSlot.copy();
            copy.setCount(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.getCount(), amount);
        ItemStack decrStackSize = this.getInv().removeItem(slot, m);
        this.getInv().setChanged();
        return decrStackSize;
    }

    @Override
    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.getInv().setItem(slot, stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return this.getInv().getMaxStackSize();
    }

    @Override
    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.getInv().canPlaceItem(slot, stack);
    }

    public Container getInv() {
        return this.inv;
    }
}

