/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import com.mojang.logging.LogUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.IdentifierException;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.network.ChannelRegistrationChangeEvent;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.NetworkContext;
import net.minecraftforge.network.NetworkInstance;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.payload.PayloadFlow;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

@ApiStatus.Internal
public class ChannelListManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Identifier NAME = Identifier.fromNamespaceAndPath((String)"forge", (String)"channel_registration");
    static final Channel<CustomPacketPayload> CHANNEL = ((PayloadFlow)ChannelBuilder.named(NAME).optional().payloadChannel().any().bidirectional()).add(Register.TYPE, Register.CODEC, ChannelListManager::register).add(Unregister.TYPE, Unregister.CODEC, ChannelListManager::unregister).build();

    private static void register(Register payload, CustomPayloadEvent.Context ctx) {
        ChannelListManager.updateFrom(ctx, payload.channels(), ChannelRegistrationChangeEvent.Type.REGISTER);
        ctx.setPacketHandled(true);
        if (ctx.isClientSide()) {
            ChannelListManager.addChannels(ctx.getConnection());
        }
    }

    private static void unregister(Unregister payload, CustomPayloadEvent.Context ctx) {
        ChannelListManager.updateFrom(ctx, payload.channels(), ChannelRegistrationChangeEvent.Type.UNREGISTER);
        ctx.setPacketHandled(true);
    }

    public static void addChannels(Connection connection) {
        ChannelListManager.addChannels(connection, NetworkRegistry.buildRegisterList());
    }

    public static void addChannels(Connection connection, Identifier ... channels) {
        ChannelListManager.addChannels(connection, Arrays.asList(channels));
    }

    public static void addChannels(Connection connection, Collection<Identifier> channels) {
        NetworkContext list = NetworkContext.get(connection);
        HashSet<String> toSend = new HashSet<String>();
        for (Identifier channel : channels) {
            if (!list.sentChannels.add(channel)) continue;
            toSend.add(channel.toString());
        }
        if (!toSend.isEmpty()) {
            CHANNEL.send((CustomPacketPayload)new Register(toSend.stream().sorted().toList()), connection);
        }
    }

    public static void removeChannels(Connection connection, Identifier ... channels) {
        ChannelListManager.removeChannels(connection, Arrays.asList(channels));
    }

    public static void removeChannels(Connection connection, Collection<Identifier> channels) {
        NetworkContext list = NetworkContext.get(connection);
        HashSet<String> toSend = new HashSet<String>();
        for (Identifier channel : channels) {
            if (!list.sentChannels.remove(channel)) continue;
            toSend.add(channel.toString());
        }
        if (!toSend.isEmpty()) {
            CHANNEL.send((CustomPacketPayload)new Unregister(toSend.stream().toList()), connection);
        }
    }

    private static void encode(FriendlyByteBuf buf, List<String> channels) {
        for (String c : channels) {
            buf.writeBytes(c.toString().getBytes(StandardCharsets.UTF_8));
            buf.writeByte(0);
        }
    }

    private static List<String> decode(FriendlyByteBuf buffer) {
        byte[] data = new byte[Math.max(buffer.readableBytes(), 0)];
        buffer.readBytes(data);
        ArrayList<String> channels = new ArrayList<String>();
        int last = 0;
        for (int cur = 0; cur < data.length; ++cur) {
            if (data[cur] != 0) continue;
            channels.add(new String(data, last, cur - last, StandardCharsets.UTF_8));
            last = cur + 1;
        }
        if (last < data.length) {
            channels.add(new String(data, last, data.length - last, StandardCharsets.UTF_8));
        }
        return Collections.unmodifiableList(channels);
    }

    private static void updateFrom(CustomPayloadEvent.Context source, List<String> channels, ChannelRegistrationChangeEvent.Type changeType) {
        HashSet<Identifier> changed = new HashSet<Identifier>();
        for (String channel : channels) {
            if (channel.isEmpty()) continue;
            try {
                changed.add(Identifier.parse((String)channel));
            }
            catch (IdentifierException ex) {
                LOGGER.warn("Invalid channel name received: {}. Ignoring", (Object)channel);
            }
        }
        ForgeEventFactory.onChannelRegistrationChange(source.getConnection(), changeType, changed);
        NetworkContext list = NetworkContext.get(source.getConnection());
        for (Identifier channel : changed) {
            NetworkInstance target;
            boolean fire = changeType == ChannelRegistrationChangeEvent.Type.UNREGISTER ? list.remoteChannels.remove(channel) : list.remoteChannels.add(channel);
            if (!fire || (target = NetworkRegistry.findTarget(channel)) == null) continue;
            target.registrationChange(channel, changeType == ChannelRegistrationChangeEvent.Type.REGISTER);
        }
    }

    private record Register(List<String> channels) implements CustomPacketPayload
    {
        private static final CustomPacketPayload.Type<Register> TYPE = CustomPacketPayload.createType((String)"register");
        private static final StreamCodec<FriendlyByteBuf, Register> CODEC = StreamCodec.of((buf, v) -> ChannelListManager.encode(buf, v.channels), buf -> new Register(ChannelListManager.decode(buf)));

        public CustomPacketPayload.Type<Register> type() {
            return TYPE;
        }
    }

    private record Unregister(List<String> channels) implements CustomPacketPayload
    {
        private static final CustomPacketPayload.Type<Unregister> TYPE = CustomPacketPayload.createType((String)"unregister");
        private static final StreamCodec<FriendlyByteBuf, Unregister> CODEC = StreamCodec.of((buf, v) -> ChannelListManager.encode(buf, v.channels), buf -> new Unregister(ChannelListManager.decode(buf)));

        public CustomPacketPayload.Type<Unregister> type() {
            return TYPE;
        }
    }
}

