/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import io.netty.util.AttributeKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.Connection;
import net.minecraft.resources.Identifier;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.NetworkContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.ServerStatusPing;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class NetworkInstance {
    private Collection<Consumer<CustomPayloadEvent>> listeners = new ArrayList<Consumer<CustomPayloadEvent>>();
    private final Identifier channelName;
    private final int networkProtocolVersion;
    final Channel.VersionTest clientAcceptedVersions;
    final Channel.VersionTest serverAcceptedVersions;
    final Map<AttributeKey<?>, Function<Connection, ?>> attributes;
    final Consumer<Connection> channelHandler;
    final ServerStatusPing.ChannelData pingData;
    private final Set<Identifier> ids = new HashSet<Identifier>();

    NetworkInstance(Identifier channelName, int networkProtocolVersion, Channel.VersionTest clientAcceptedVersions, Channel.VersionTest serverAcceptedVersions, Map<AttributeKey<?>, Function<Connection, ?>> attributes, Consumer<Connection> channelHandler) {
        this.channelName = channelName;
        this.networkProtocolVersion = networkProtocolVersion;
        this.clientAcceptedVersions = clientAcceptedVersions;
        this.serverAcceptedVersions = serverAcceptedVersions;
        this.attributes = attributes;
        this.channelHandler = channelHandler;
        this.pingData = new ServerStatusPing.ChannelData(channelName, networkProtocolVersion, this.clientAcceptedVersions.accepts(Channel.VersionTest.Status.MISSING, -1));
    }

    public void addListener(Consumer<CustomPayloadEvent> eventListener) {
        this.listeners.add(eventListener);
    }

    public boolean dispatch(CustomPayloadEvent event) {
        for (Consumer<CustomPayloadEvent> listener : this.listeners) {
            listener.accept(event);
        }
        return event.getSource().getPacketHandled();
    }

    public NetworkInstance addChild(Identifier name) {
        NetworkRegistry.register(this, name);
        this.ids.add(name);
        return this;
    }

    Identifier getChannelName() {
        return this.channelName;
    }

    int getNetworkProtocolVersion() {
        return this.networkProtocolVersion;
    }

    void registrationChange(Identifier name, boolean registered) {
    }

    boolean isRemotePresent(Connection con) {
        Set<Identifier> channels = NetworkContext.get(con).getRemoteChannels();
        return channels.containsAll(this.ids);
    }
}

