/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraftforge.registries.ForgeRegistry;

public record RegistryData(int token, Identifier name, ForgeRegistry.Snapshot data) {
    public static final StreamCodec<FriendlyByteBuf, RegistryData> STREAM_CODEC = StreamCodec.ofMember(RegistryData::encode, RegistryData::decode);

    public void encode(FriendlyByteBuf buf) {
        buf.writeVarInt(this.token);
        buf.writeIdentifier(this.name);
        buf.writeBytes((ByteBuf)this.data.getPacketData());
    }

    public static RegistryData decode(FriendlyByteBuf buf) {
        return new RegistryData(buf.readVarInt(), buf.readIdentifier(), ForgeRegistry.Snapshot.read(buf));
    }
}

