/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network.packets;

import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.registries.DataPackRegistriesHooks;
import net.minecraftforge.registries.RegistryManager;

public record RegistryList(int token, List<Identifier> normal, List<ResourceKey<? extends Registry<?>>> datapacks) {
    public static final StreamCodec<FriendlyByteBuf, RegistryList> STREAM_CODEC = StreamCodec.ofMember(RegistryList::encode, RegistryList::decode);

    public RegistryList(int token) {
        this(token, RegistryManager.getRegistryNamesForSyncToClient(), List.copyOf(DataPackRegistriesHooks.getSyncedCustomRegistries()));
    }

    public static RegistryList decode(FriendlyByteBuf buf) {
        int token = buf.readVarInt();
        List normal = buf.readList(FriendlyByteBuf::readIdentifier);
        List datapacks = buf.readList(b -> ResourceKey.createRegistryKey((Identifier)buf.readIdentifier()));
        return new RegistryList(token, normal, datapacks);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeVarInt(this.token());
        buf.writeCollection(this.normal(), FriendlyByteBuf::writeIdentifier);
        buf.writeCollection(this.datapacks(), FriendlyByteBuf::writeResourceKey);
    }
}

