/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.resources.Identifier;
import net.minecraftforge.registries.ForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
class ObjectHolderRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<Consumer<Predicate<Identifier>>> objectHolders = new HashSet<Consumer<Predicate<Identifier>>>();

    ObjectHolderRegistry() {
    }

    static synchronized void addHandler(Consumer<Predicate<Identifier>> ref) {
        objectHolders.add(ref);
    }

    static synchronized boolean removeHandler(Consumer<Predicate<Identifier>> ref) {
        return objectHolders.remove(ref);
    }

    static void applyObjectHolders() {
        try {
            LOGGER.debug(ForgeRegistry.REGISTRIES, "Applying holder lookups");
            ObjectHolderRegistry.applyObjectHolders(key -> true);
            LOGGER.debug(ForgeRegistry.REGISTRIES, "Holder lookups applied");
        }
        catch (RuntimeException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    static void applyObjectHolders(Predicate<Identifier> filter) {
        RuntimeException aggregate = new RuntimeException("Failed to apply some object holders, see suppressed exceptions for details");
        for (Consumer<Predicate<Identifier>> objectHolder : objectHolders) {
            try {
                objectHolder.accept(filter);
            }
            catch (Exception e) {
                aggregate.addSuppressed(e);
            }
        }
        if (aggregate.getSuppressed().length > 0) {
            throw aggregate;
        }
    }
}

