/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.eventbus.internal.Event;
import net.minecraftforge.registries.DataPackRegistryEvent;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NamespacedWrapper;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

public class RegistryManager {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final RegistryManager ACTIVE = new RegistryManager("ACTIVE");
    public static final RegistryManager VANILLA = new RegistryManager("VANILLA");
    public static final RegistryManager FROZEN = new RegistryManager("FROZEN");
    private static Set<Identifier> vanillaRegistryKeys = Set.of();
    BiMap<Identifier, ForgeRegistry<?>> registries = HashBiMap.create();
    private final Map<Identifier, ? extends IForgeRegistry<?>> registryView = Collections.unmodifiableMap(this.registries);
    private final Set<Identifier> persisted = new HashSet<Identifier>();
    private final Set<Identifier> synced = new HashSet<Identifier>();
    private final Map<Identifier, Identifier> legacyNames = new HashMap<Identifier, Identifier>();
    private final String name;

    RegistryManager() {
        this("STAGING");
    }

    public RegistryManager(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    boolean isStaging() {
        return "STAGING".equals(this.name);
    }

    public <V> ForgeRegistry<V> getRegistry(Identifier key) {
        return (ForgeRegistry)this.registries.get((Object)key);
    }

    public <V> ForgeRegistry<V> getRegistry(ResourceKey<? extends Registry<V>> key) {
        return this.getRegistry(key.identifier());
    }

    public <V> Identifier getName(IForgeRegistry<V> reg) {
        return (Identifier)this.registries.inverse().get(reg);
    }

    public Map<Identifier, ? extends IForgeRegistry<?>> getRegistries() {
        return this.registryView;
    }

    public static Set<Identifier> getVanillaRegistryKeys() {
        return vanillaRegistryKeys;
    }

    public <V> Identifier updateLegacyName(Identifier legacyName) {
        Identifier originalName = legacyName;
        while (this.getRegistry(legacyName) == null) {
            if ((legacyName = this.legacyNames.get(legacyName)) != null) continue;
            return originalName;
        }
        return legacyName;
    }

    public <V> ForgeRegistry<V> getRegistry(Identifier key, RegistryManager other) {
        if (!this.registries.containsKey((Object)key)) {
            ForgeRegistry<V> ot = other.getRegistry(key);
            if (ot == null) {
                return null;
            }
            this.registries.put((Object)key, ot.copy(this));
            if (other.persisted.contains(key)) {
                this.persisted.add(key);
            }
            if (other.synced.contains(key)) {
                this.synced.add(key);
            }
            other.legacyNames.entrySet().stream().filter(e -> ((Identifier)e.getValue()).equals((Object)key)).forEach(e -> this.addLegacyName((Identifier)e.getKey(), (Identifier)e.getValue()));
        }
        return this.getRegistry(key);
    }

    <V> ForgeRegistry<V> createRegistry(Identifier name, RegistryBuilder<V> builder) {
        if (this.registries.containsKey((Object)name)) {
            throw new IllegalArgumentException("Attempted to register a registry for " + String.valueOf(name) + " but it already exists");
        }
        ForgeRegistry<V> reg = new ForgeRegistry<V>(this, name, builder);
        this.registries.put((Object)name, reg);
        if (builder.getSaveToDisc()) {
            this.persisted.add(name);
        }
        if (builder.getSync()) {
            this.synced.add(name);
        }
        for (Identifier legacyName : builder.getLegacyNames()) {
            this.addLegacyName(legacyName, name);
        }
        return this.getRegistry(name);
    }

    static <V> void registerToRootRegistry(ForgeRegistry<V> forgeReg) {
        RegistryManager.injectForgeRegistry(forgeReg, BuiltInRegistries.REGISTRY);
    }

    private static <V> void injectForgeRegistry(ForgeRegistry<V> forgeReg, Registry<? extends Registry<?>> rootRegistry) {
        WritableRegistry registry = (WritableRegistry)rootRegistry;
        NamespacedWrapper<V> wrapper = forgeReg.getWrapper();
        if (wrapper != null) {
            registry.register(forgeReg.getRegistryKey(), wrapper, RegistrationInfo.BUILT_IN);
        }
    }

    public static void postNewRegistryEvent() {
        vanillaRegistryKeys = Set.copyOf(BuiltInRegistries.REGISTRY.keySet());
        NewRegistryEvent event = (NewRegistryEvent)NewRegistryEvent.BUS.fire((Event)new NewRegistryEvent());
        DataPackRegistryEvent.NewRegistry dataPackEvent = (DataPackRegistryEvent.NewRegistry)DataPackRegistryEvent.NewRegistry.BUS.fire((Event)new DataPackRegistryEvent.NewRegistry());
        event.fill();
        dataPackEvent.process();
    }

    private void addLegacyName(Identifier legacyName, Identifier name) {
        if (this.legacyNames.containsKey(legacyName)) {
            throw new IllegalArgumentException("Legacy name conflict for registry " + String.valueOf(name) + ", upgrade path must be linear: " + String.valueOf(legacyName));
        }
        this.legacyNames.put(legacyName, name);
    }

    public Map<Identifier, ForgeRegistry.Snapshot> takeSnapshot(boolean savingToDisc) {
        HashMap<Identifier, ForgeRegistry.Snapshot> ret = new HashMap<Identifier, ForgeRegistry.Snapshot>();
        Set<Identifier> keys = savingToDisc ? this.persisted : this.synced;
        for (Identifier key : keys) {
            ret.put(key, this.getRegistry(key).makeSnapshot());
        }
        return ret;
    }

    @ApiStatus.Internal
    public void clean() {
        this.persisted.clear();
        this.synced.clear();
        this.registries.clear();
    }

    @ApiStatus.Internal
    public static List<Identifier> getRegistryNamesForSyncToClient() {
        return RegistryManager.ACTIVE.registries.keySet().stream().filter(RegistryManager.ACTIVE.synced::contains).toList();
    }
}

