/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.ForgeI18n;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LanguageHook {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new Gson();
    private static final Pattern PATTERN = Pattern.compile("%(\\d+\\$)?[\\d\\.]*[df]");
    private static final List<Map<String, String>> CAPTURED_TABLES = new ArrayList<Map<String, String>>();
    private static Map<String, String> modTable;

    public static void captureLanguageMap(Map<String, String> table) {
        CAPTURED_TABLES.add(table);
        if (modTable != null) {
            CAPTURED_TABLES.forEach(t -> t.putAll(modTable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLocaleData(InputStream inputstream) {
        try {
            JsonElement jsonelement = (JsonElement)GSON.fromJson((Reader)new InputStreamReader(inputstream, StandardCharsets.UTF_8), JsonElement.class);
            JsonObject jsonobject = GsonHelper.convertToJsonObject((JsonElement)jsonelement, (String)"strings");
            for (Map.Entry entry : jsonobject.entrySet()) {
                String s = PATTERN.matcher(GsonHelper.convertToString((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()))).replaceAll("%$1s");
                modTable.put((String)entry.getKey(), s);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputstream);
        }
    }

    private static void loadLanguage(String langName, MinecraftServer server) {
        String langFile = String.format(Locale.ROOT, "lang/%s.json", langName);
        CloseableResourceManager resourceManager = server.getServerResources().resourceManager();
        HashMap<String, List> byNamespace = new HashMap<String, List>();
        ArrayList packs = new ArrayList(resourceManager.listPacks().toList());
        HashSet seen = new HashSet(packs);
        while (!packs.isEmpty()) {
            PackResources pack = (PackResources)packs.removeFirst();
            if (pack.getChildren() != null) {
                for (PackResources child : pack.getChildren()) {
                    if (!seen.add(child)) continue;
                    packs.add(child);
                }
            }
            for (String namespace : pack.getNamespaces(PackType.CLIENT_RESOURCES)) {
                byNamespace.computeIfAbsent(namespace, k -> new ArrayList()).add(pack);
            }
        }
        for (Map.Entry entry : byNamespace.entrySet()) {
            ArrayList<IoSupplier> languages = new ArrayList<IoSupplier>();
            Identifier path = Identifier.fromNamespaceAndPath((String)((String)entry.getKey()), (String)langFile);
            for (PackResources pack : (List)entry.getValue()) {
                IoSupplier io = pack.getResource(PackType.CLIENT_RESOURCES, path);
                if (io == null) continue;
                languages.add(io);
            }
            while (!languages.isEmpty()) {
                try {
                    InputStream stream = (InputStream)((IoSupplier)languages.removeLast()).get();
                    try {
                        LanguageHook.loadLocaleData(stream);
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn("Skipped language file: {}:{}", entry.getKey(), (Object)langFile, (Object)exception);
                }
            }
        }
    }

    public static void loadForgeAndMCLangs() {
        modTable = new HashMap<String, String>(5000);
        InputStream mc = Thread.currentThread().getContextClassLoader().getResourceAsStream("assets/minecraft/lang/en_us.json");
        InputStream forge = Thread.currentThread().getContextClassLoader().getResourceAsStream("assets/forge/lang/en_us.json");
        LanguageHook.loadLocaleData(mc);
        LanguageHook.loadLocaleData(forge);
        CAPTURED_TABLES.forEach(t -> t.putAll(modTable));
        ForgeI18n.loadLanguageData(modTable);
    }

    static void loadLanguagesOnServer(MinecraftServer server) {
        modTable = new HashMap<String, String>(5000);
        LanguageHook.loadLanguage("en_us", server);
        CAPTURED_TABLES.forEach(t -> t.putAll(modTable));
        ForgeI18n.loadLanguageData(modTable);
    }
}

