/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.permissions.PermissionCheck;

class DimensionsCommand {
    DimensionsCommand() {
    }

    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"dimensions").requires((Predicate)Commands.hasPermission((PermissionCheck)Commands.LEVEL_ALL))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.forge.dimensions.list"), true);
            Registry reg = ((CommandSourceStack)ctx.getSource()).registryAccess().lookupOrThrow(Registries.DIMENSION_TYPE);
            HashMap<Identifier, List> types = new HashMap<Identifier, List>();
            for (ServerLevel dim : ((CommandSourceStack)ctx.getSource()).getServer().getAllLevels()) {
                types.computeIfAbsent(reg.getKey((Object)dim.dimensionType()), k -> new ArrayList()).add(dim.dimension().identifier());
            }
            types.keySet().stream().sorted().forEach(key -> ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)(String.valueOf(key) + ": " + ((List)types.get(key)).stream().map(Identifier::toString).sorted().collect(Collectors.joining(", ")))), false));
            return 0;
        });
    }
}

