/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.permissions.PermissionCheck;
import net.minecraftforge.common.WorldWorkerManager;
import net.minecraftforge.server.command.ChunkGenWorker;

class GenerateCommand {
    GenerateCommand() {
    }

    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"generate").requires((Predicate)Commands.hasPermission((PermissionCheck)Commands.LEVEL_OWNERS))).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).then(((RequiredArgumentBuilder)Commands.argument((String)"dim", (ArgumentType)DimensionArgument.dimension()).then(Commands.argument((String)"interval", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> GenerateCommand.execute((CommandSourceStack)ctx.getSource(), BlockPosArgument.getSpawnablePos((CommandContext)ctx, (String)"pos"), GenerateCommand.getInt((CommandContext<CommandSourceStack>)ctx, "count"), DimensionArgument.getDimension((CommandContext)ctx, (String)"dim"), GenerateCommand.getInt((CommandContext<CommandSourceStack>)ctx, "interval"))))).executes(ctx -> GenerateCommand.execute((CommandSourceStack)ctx.getSource(), BlockPosArgument.getSpawnablePos((CommandContext)ctx, (String)"pos"), GenerateCommand.getInt((CommandContext<CommandSourceStack>)ctx, "count"), DimensionArgument.getDimension((CommandContext)ctx, (String)"dim"), -1)))).executes(ctx -> GenerateCommand.execute((CommandSourceStack)ctx.getSource(), BlockPosArgument.getSpawnablePos((CommandContext)ctx, (String)"pos"), GenerateCommand.getInt((CommandContext<CommandSourceStack>)ctx, "count"), ((CommandSourceStack)ctx.getSource()).getLevel(), -1))));
    }

    private static int getInt(CommandContext<CommandSourceStack> ctx, String name) {
        return IntegerArgumentType.getInteger(ctx, (String)name);
    }

    private static int execute(CommandSourceStack source, BlockPos pos, int count, ServerLevel dim, int interval) {
        BlockPos chunkpos = new BlockPos(pos.getX() >> 4, 0, pos.getZ() >> 4);
        ChunkGenWorker worker = new ChunkGenWorker(source, chunkpos, count, dim, interval);
        source.sendSuccess(() -> worker.getStartMessage(source), true);
        WorldWorkerManager.addWorker(worker);
        return 0;
    }
}

