/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.PlayerSkinRenderCache;
import net.minecraft.client.renderer.SpecialBlockModelRenderer;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.item.ClientItem;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.AtlasManager;
import net.minecraft.client.resources.model.BlockStateModelLoader;
import net.minecraft.client.resources.model.ClientItemInfoLoader;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.client.resources.model.MissingBlockModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelDiscovery;
import net.minecraft.client.resources.model.ModelGroupCollector;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.SpriteGetter;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.AtlasIds;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.Zone;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.geometry.GeometryLoaderManager;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ModelManager
implements PreparableReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final FileToIdConverter MODEL_LISTER = FileToIdConverter.json("models");
    private Map<ResourceLocation, ItemModel> bakedItemStackModels = Map.of();
    private Map<ResourceLocation, ItemModel> bakedItemStackModelsView = Map.of();
    private Map<ResourceLocation, ClientItem.Properties> itemProperties = Map.of();
    private final AtlasManager atlasManager;
    private final PlayerSkinRenderCache playerSkinRenderCache;
    private final BlockModelShaper blockModelShaper;
    private final BlockColors blockColors;
    private EntityModelSet entityModelSet = EntityModelSet.EMPTY;
    private SpecialBlockModelRenderer specialBlockModelRenderer = SpecialBlockModelRenderer.EMPTY;
    private ModelBakery.MissingModels missingModels;
    private Object2IntMap<BlockState> modelGroups = Object2IntMaps.emptyMap();
    private ModelBakery modelBakery;

    public ModelManager(BlockColors p_119407_, AtlasManager p_423190_, PlayerSkinRenderCache p_429874_) {
        this.blockColors = p_119407_;
        this.atlasManager = p_423190_;
        this.playerSkinRenderCache = p_429874_;
        this.blockModelShaper = new BlockModelShaper(this);
    }

    public BlockStateModel getMissingBlockStateModel() {
        return this.missingModels.block();
    }

    public ItemModel getItemModel(ResourceLocation p_376816_) {
        return this.bakedItemStackModels.getOrDefault(p_376816_, this.missingModels.item());
    }

    public Map<ResourceLocation, ItemModel> getItemModels() {
        return this.bakedItemStackModelsView;
    }

    public ClientItem.Properties getItemProperties(ResourceLocation p_378319_) {
        return this.itemProperties.getOrDefault(p_378319_, ClientItem.Properties.DEFAULT);
    }

    public BlockModelShaper getBlockModelShaper() {
        return this.blockModelShaper;
    }

    @Override
    public final CompletableFuture<Void> reload(PreparableReloadListener.SharedState p_427489_, Executor p_250550_, PreparableReloadListener.PreparationBarrier p_249079_, Executor p_249221_) {
        GeometryLoaderManager.init();
        ResourceManager resourcemanager = p_427489_.resourceManager();
        CompletableFuture<EntityModelSet> completablefuture = CompletableFuture.supplyAsync(EntityModelSet::vanilla, p_250550_);
        CompletionStage completablefuture1 = completablefuture.thenApplyAsync(p_421066_ -> SpecialBlockModelRenderer.vanilla((SpecialModelRenderer.BakingContext)new SpecialModelRenderer.BakingContext.Simple(p_421066_, (MaterialSet)this.atlasManager, this.playerSkinRenderCache)), p_250550_);
        CompletableFuture<Map<ResourceLocation, UnbakedModel>> completablefuture2 = ModelManager.loadBlockModels(resourcemanager, p_250550_);
        CompletableFuture completablefuture3 = BlockStateModelLoader.loadBlockStates((ResourceManager)resourcemanager, (Executor)p_250550_);
        CompletableFuture completablefuture4 = ClientItemInfoLoader.scheduleLoad((ResourceManager)resourcemanager, (Executor)p_250550_);
        CompletionStage completablefuture5 = CompletableFuture.allOf(completablefuture2, completablefuture3, completablefuture4).thenApplyAsync(p_389625_ -> ModelManager.discoverModelDependencies((Map)completablefuture2.join(), (BlockStateModelLoader.LoadedModels)completablefuture3.join(), (ClientItemInfoLoader.LoadedClientInfos)completablefuture4.join()), p_250550_);
        CompletionStage completablefuture6 = completablefuture3.thenApplyAsync(p_358038_ -> ModelManager.buildModelGroups(this.blockColors, p_358038_), p_250550_);
        CompletableFuture completablefuture7 = ((AtlasManager.PendingStitchResults)p_427489_.get(AtlasManager.PENDING_STITCH)).get(AtlasIds.BLOCKS);
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(new CompletableFuture[]{completablefuture7, completablefuture5, completablefuture6, completablefuture3, completablefuture4, completablefuture, completablefuture1, completablefuture2}).thenComposeAsync(arg_0 -> this.lambda$reload$4(completablefuture7, (CompletableFuture)completablefuture5, (CompletableFuture)completablefuture6, completablefuture2, completablefuture, completablefuture3, completablefuture4, (CompletableFuture)completablefuture1, p_250550_, arg_0), p_250550_)).thenCompose(p_249079_::wait)).thenAcceptAsync(this::apply, p_249221_);
    }

    private static CompletableFuture<Map<ResourceLocation, UnbakedModel>> loadBlockModels(ResourceManager p_251361_, Executor p_252189_) {
        return CompletableFuture.supplyAsync(() -> MODEL_LISTER.listMatchingResources(p_251361_), p_252189_).thenCompose(p_250597_ -> {
            ArrayList<CompletableFuture<Pair>> list = new ArrayList<CompletableFuture<Pair>>(p_250597_.size());
            for (Map.Entry entry : p_250597_.entrySet()) {
                list.add(CompletableFuture.supplyAsync(() -> {
                    ResourceLocation resourcelocation = MODEL_LISTER.fileToId((ResourceLocation)entry.getKey());
                    try {
                        Pair pair;
                        try (BufferedReader reader = ((Resource)entry.getValue()).openAsReader();){
                            pair = Pair.of((Object)resourcelocation, (Object)BlockModel.fromStream(reader));
                        }
                        return pair;
                    }
                    catch (Exception exception) {
                        LOGGER.error("Failed to load model {}", entry.getKey(), (Object)exception);
                        return null;
                    }
                }, p_252189_));
            }
            return Util.sequence(list).thenApply(p_250813_ -> p_250813_.stream().filter(Objects::nonNull).collect(Collectors.toUnmodifiableMap(Pair::getFirst, Pair::getSecond)));
        });
    }

    private static ResolvedModels discoverModelDependencies(Map<ResourceLocation, UnbakedModel> p_360749_, BlockStateModelLoader.LoadedModels p_366446_, ClientItemInfoLoader.LoadedClientInfos p_378505_) {
        ResolvedModels modelmanager$resolvedmodels;
        try (Zone zone = Profiler.get().zone("dependencies");){
            ModelDiscovery modeldiscovery = new ModelDiscovery(p_360749_, MissingBlockModel.missingModel());
            modeldiscovery.addSpecialModel(ItemModelGenerator.GENERATED_ITEM_MODEL_ID, (UnbakedModel)new ItemModelGenerator());
            p_366446_.models().values().forEach(modeldiscovery::addRoot);
            p_378505_.contents().values().forEach(p_374734_ -> modeldiscovery.addRoot((ResolvableModel)p_374734_.model()));
            modelmanager$resolvedmodels = new ResolvedModels(modeldiscovery.missingModel(), modeldiscovery.resolve());
        }
        return modelmanager$resolvedmodels;
    }

    private static CompletableFuture<ReloadState> loadModels(final SpriteLoader.Preparations p_422832_, ModelBakery p_248945_, Object2IntMap<BlockState> p_361513_, EntityModelSet p_378097_, SpecialBlockModelRenderer p_377275_, Executor p_394729_) {
        final Multimap multimap = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
        final Multimap multimap1 = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
        return p_248945_.bakeModels(new SpriteGetter(){
            private final TextureAtlasSprite missingSprite;
            {
                this.missingSprite = p_422832_.missing();
            }

            public TextureAtlasSprite get(Material p_375858_, ModelDebugName p_375833_) {
                TextureAtlasSprite textureatlassprite;
                if (p_375858_.atlasLocation().equals(TextureAtlas.LOCATION_BLOCKS) && (textureatlassprite = p_422832_.getSprite(p_375858_.texture())) != null) {
                    return textureatlassprite;
                }
                multimap.put((Object)p_375833_.debugName(), (Object)p_375858_);
                return this.missingSprite;
            }

            public TextureAtlasSprite reportMissingReference(String p_378821_, ModelDebugName p_377684_) {
                multimap1.put((Object)p_377684_.debugName(), (Object)p_378821_);
                return this.missingSprite;
            }
        }, p_394729_).thenApply(p_421082_ -> {
            ForgeHooksClient.onModifyBakingResult((ModelBakery)p_248945_, (ModelBakery.BakingResult)p_421082_);
            multimap.asMap().forEach((p_376688_, p_252017_) -> LOGGER.warn("Missing textures in model {}:\n{}", p_376688_, (Object)p_252017_.stream().sorted(Material.COMPARATOR).map(p_325574_ -> "    " + String.valueOf(p_325574_.atlasLocation()) + ":" + String.valueOf(p_325574_.texture())).collect(Collectors.joining("\n"))));
            multimap1.asMap().forEach((p_374739_, p_374740_) -> LOGGER.warn("Missing texture references in model {}:\n{}", p_374739_, (Object)p_374740_.stream().sorted().map(p_374742_ -> "    " + p_374742_).collect(Collectors.joining("\n"))));
            Map<BlockState, BlockStateModel> map = ModelManager.createBlockStateToModelDispatch(p_421082_.blockStateModels(), p_421082_.missingModels().block());
            return new ReloadState((ModelBakery.BakingResult)p_421082_, p_361513_, map, p_378097_, p_377275_, p_248945_);
        });
    }

    private static Map<BlockState, BlockStateModel> createBlockStateToModelDispatch(Map<BlockState, BlockStateModel> p_377857_, BlockStateModel p_396223_) {
        IdentityHashMap<BlockState, BlockStateModel> object;
        try (Zone zone = Profiler.get().zone("block state dispatch");){
            IdentityHashMap<BlockState, BlockStateModel> map = new IdentityHashMap<BlockState, BlockStateModel>(p_377857_);
            for (Block block : BuiltInRegistries.BLOCK) {
                block.getStateDefinition().getPossibleStates().forEach(p_389628_ -> {
                    if (p_377857_.putIfAbsent((BlockState)p_389628_, p_396223_) == null) {
                        LOGGER.warn("Missing model for variant: '{}'", p_389628_);
                    }
                });
            }
            object = map;
        }
        return object;
    }

    private static Object2IntMap<BlockState> buildModelGroups(BlockColors p_369941_, BlockStateModelLoader.LoadedModels p_360724_) {
        Object2IntMap object2intmap;
        try (Zone zone = Profiler.get().zone("block groups");){
            object2intmap = ModelGroupCollector.build((BlockColors)p_369941_, (BlockStateModelLoader.LoadedModels)p_360724_);
        }
        return object2intmap;
    }

    private void apply(ReloadState p_248996_) {
        ModelBakery.BakingResult modelbakery$bakingresult = p_248996_.bakedModels;
        this.bakedItemStackModels = modelbakery$bakingresult.itemStackModels();
        this.bakedItemStackModelsView = Collections.unmodifiableMap(this.bakedItemStackModels);
        this.itemProperties = modelbakery$bakingresult.itemProperties();
        this.modelGroups = p_248996_.modelGroups;
        this.missingModels = modelbakery$bakingresult.missingModels();
        this.modelBakery = p_248996_.modelBakery();
        ForgeHooksClient.onModelBake((ModelManager)this, (ModelBakery)this.modelBakery);
        this.blockModelShaper.replaceCache(p_248996_.modelCache);
        this.specialBlockModelRenderer = p_248996_.specialBlockModelRenderer;
        this.entityModelSet = p_248996_.entityModelSet;
    }

    public boolean requiresRender(BlockState p_119416_, BlockState p_119417_) {
        int j;
        if (p_119416_ == p_119417_) {
            return false;
        }
        int i = this.modelGroups.getInt((Object)p_119416_);
        if (i != -1 && i == (j = this.modelGroups.getInt((Object)p_119417_))) {
            FluidState fluidstate1;
            FluidState fluidstate = p_119416_.getFluidState();
            return fluidstate != (fluidstate1 = p_119417_.getFluidState());
        }
        return true;
    }

    public ModelBakery getModelBakery() {
        return (ModelBakery)Preconditions.checkNotNull((Object)this.modelBakery, (Object)"Attempted to query model bakery before it has been initialized.");
    }

    public Supplier<SpecialBlockModelRenderer> specialBlockModelRenderer() {
        return () -> this.specialBlockModelRenderer;
    }

    public Supplier<EntityModelSet> entityModels() {
        return () -> this.entityModelSet;
    }

    private /* synthetic */ CompletionStage lambda$reload$4(CompletableFuture completablefuture7, CompletableFuture completablefuture5, CompletableFuture completablefuture6, CompletableFuture completablefuture2, CompletableFuture completablefuture, CompletableFuture completablefuture3, CompletableFuture completablefuture4, CompletableFuture completablefuture1, Executor p_250550_, Void p_421076_) {
        SpriteLoader.Preparations spriteloader$preparations = (SpriteLoader.Preparations)completablefuture7.join();
        ResolvedModels modelmanager$resolvedmodels = (ResolvedModels)completablefuture5.join();
        Object2IntMap object2intmap = (Object2IntMap)completablefuture6.join();
        Sets.SetView set = Sets.difference(((Map)completablefuture2.join()).keySet(), modelmanager$resolvedmodels.models.keySet());
        if (!set.isEmpty()) {
            LOGGER.debug("Unreferenced models: \n{}", (Object)set.stream().sorted().map(p_374723_ -> "\t" + String.valueOf(p_374723_) + "\n").collect(Collectors.joining()));
        }
        ModelBakery modelbakery = new ModelBakery((EntityModelSet)completablefuture.join(), (MaterialSet)this.atlasManager, this.playerSkinRenderCache, ((BlockStateModelLoader.LoadedModels)completablefuture3.join()).models(), ((ClientItemInfoLoader.LoadedClientInfos)completablefuture4.join()).contents(), modelmanager$resolvedmodels.models(), modelmanager$resolvedmodels.missing());
        return ModelManager.loadModels(spriteloader$preparations, modelbakery, (Object2IntMap<BlockState>)object2intmap, (EntityModelSet)completablefuture.join(), (SpecialBlockModelRenderer)completablefuture1.join(), p_250550_);
    }

    @OnlyIn(value=Dist.CLIENT)
    record ResolvedModels(ResolvedModel missing, Map<ResourceLocation, ResolvedModel> models) {
    }

    @OnlyIn(value=Dist.CLIENT)
    record ReloadState(ModelBakery.BakingResult bakedModels, Object2IntMap<BlockState> modelGroups, Map<BlockState, BlockStateModel> modelCache, EntityModelSet entityModelSet, SpecialBlockModelRenderer specialBlockModelRenderer, ModelBakery modelBakery) {
    }
}

