/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.resources.DelegatingOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;

public class RegistryOps<T>
extends DelegatingOps<T> {
    private final RegistryInfoLookup lookupProvider;

    public static <T> RegistryOps<T> create(DynamicOps<T> p_256342_, HolderLookup.Provider p_255950_) {
        return RegistryOps.create(p_256342_, new HolderLookupAdapter(p_255950_));
    }

    public static <T> RegistryOps<T> create(DynamicOps<T> p_256278_, RegistryInfoLookup p_256479_) {
        return new RegistryOps<T>(p_256278_, p_256479_);
    }

    public static <T> Dynamic<T> injectRegistryContext(Dynamic<T> p_331489_, HolderLookup.Provider p_331408_) {
        return new Dynamic(p_331408_.createSerializationContext(p_331489_.getOps()), p_331489_.getValue());
    }

    private RegistryOps(DynamicOps<T> p_256313_, RegistryInfoLookup p_255799_) {
        super(p_256313_);
        this.lookupProvider = p_255799_;
    }

    public <U> RegistryOps<U> withParent(DynamicOps<U> p_332969_) {
        return p_332969_ == this.delegate ? this : new RegistryOps<U>(p_332969_, this.lookupProvider);
    }

    public <E> Optional<HolderOwner<E>> owner(ResourceKey<? extends Registry<? extends E>> p_255757_) {
        return this.lookupProvider.lookup(p_255757_).map(RegistryInfo::owner);
    }

    public <E> Optional<HolderGetter<E>> getter(ResourceKey<? extends Registry<? extends E>> p_256031_) {
        return this.lookupProvider.lookup(p_256031_).map(RegistryInfo::getter);
    }

    public boolean equals(Object p_332753_) {
        if (this == p_332753_) {
            return true;
        }
        if (p_332753_ != null && this.getClass() == p_332753_.getClass()) {
            RegistryOps registryops = (RegistryOps)p_332753_;
            return this.delegate.equals((Object)registryops.delegate) && this.lookupProvider.equals(registryops.lookupProvider);
        }
        return false;
    }

    public int hashCode() {
        return this.delegate.hashCode() * 31 + this.lookupProvider.hashCode();
    }

    public static <E, O> RecordCodecBuilder<O, HolderGetter<E>> retrieveGetter(ResourceKey<? extends Registry<? extends E>> p_206833_) {
        return ExtraCodecs.retrieveContext(p_274811_ -> {
            DataResult dataResult;
            if (p_274811_ instanceof RegistryOps) {
                RegistryOps registryops = (RegistryOps)p_274811_;
                dataResult = registryops.lookupProvider.lookup(p_206833_).map(p_255527_ -> DataResult.success(p_255527_.getter(), (Lifecycle)p_255527_.elementsLifecycle())).orElseGet(() -> DataResult.error(() -> "Unknown registry: " + String.valueOf(p_206833_)));
            } else {
                dataResult = DataResult.error(() -> "Not a registry ops");
            }
            return dataResult;
        }).forGetter(p_255526_ -> null);
    }

    public static <E> MapCodec<HolderLookup.RegistryLookup<E>> retrieveRegistryLookup(ResourceKey<? extends Registry<? extends E>> resourceKey) {
        return ExtraCodecs.retrieveContext(ops -> {
            if (!(ops instanceof RegistryOps)) {
                return DataResult.error(() -> "Not a registry ops");
            }
            RegistryOps registryOps = (RegistryOps)ops;
            return registryOps.lookupProvider.lookup(resourceKey).map(registryInfo -> {
                HolderOwner patt0$temp = registryInfo.owner();
                if (!(patt0$temp instanceof HolderLookup.RegistryLookup)) {
                    return DataResult.error(() -> "Found holder getter but was not a registry lookup for " + String.valueOf(resourceKey));
                }
                HolderLookup.RegistryLookup registryLookup = (HolderLookup.RegistryLookup)patt0$temp;
                return DataResult.success((Object)registryLookup, (Lifecycle)registryInfo.elementsLifecycle());
            }).orElseGet(() -> DataResult.error(() -> "Unknown registry: " + String.valueOf(resourceKey)));
        });
    }

    public static <E, O> RecordCodecBuilder<O, Holder.Reference<E>> retrieveElement(ResourceKey<E> p_256347_) {
        ResourceKey resourcekey = ResourceKey.createRegistryKey(p_256347_.registry());
        return ExtraCodecs.retrieveContext(p_274808_ -> {
            DataResult dataResult;
            if (p_274808_ instanceof RegistryOps) {
                RegistryOps registryops = (RegistryOps)p_274808_;
                dataResult = registryops.lookupProvider.lookup(resourcekey).flatMap(p_255518_ -> p_255518_.getter().get(p_256347_)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Can't find value: " + String.valueOf(p_256347_)));
            } else {
                dataResult = DataResult.error(() -> "Not a registry ops");
            }
            return dataResult;
        }).forGetter(p_255524_ -> null);
    }

    static final class HolderLookupAdapter
    implements RegistryInfoLookup {
        private final HolderLookup.Provider lookupProvider;
        private final Map<ResourceKey<? extends Registry<?>>, Optional<? extends RegistryInfo<?>>> lookups = new ConcurrentHashMap();

        public HolderLookupAdapter(HolderLookup.Provider p_335468_) {
            this.lookupProvider = p_335468_;
        }

        public <E> Optional<RegistryInfo<E>> lookup(ResourceKey<? extends Registry<? extends E>> p_330389_) {
            return this.lookups.computeIfAbsent(p_330389_, this::createLookup);
        }

        private Optional<RegistryInfo<Object>> createLookup(ResourceKey<? extends Registry<?>> p_335602_) {
            return this.lookupProvider.lookup(p_335602_).map(RegistryInfo::fromRegistryLookup);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object p_330775_) {
            if (this == p_330775_) {
                return true;
            }
            if (!(p_330775_ instanceof HolderLookupAdapter)) return false;
            HolderLookupAdapter registryops$holderlookupadapter = (HolderLookupAdapter)p_330775_;
            if (!this.lookupProvider.equals(registryops$holderlookupadapter.lookupProvider)) return false;
            return true;
        }

        public int hashCode() {
            return this.lookupProvider.hashCode();
        }
    }

    public static interface RegistryInfoLookup {
        public <T> Optional<RegistryInfo<T>> lookup(ResourceKey<? extends Registry<? extends T>> var1);
    }

    public record RegistryInfo<T>(HolderOwner<T> owner, HolderGetter<T> getter, Lifecycle elementsLifecycle) {
        public static <T> RegistryInfo<T> fromRegistryLookup(HolderLookup.RegistryLookup<T> p_329148_) {
            return new RegistryInfo<T>(p_329148_, p_329148_, p_329148_.registryLifecycle());
        }
    }
}

