/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.DragonFlightHistory;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhaseManager;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.level.pathfinder.BinaryHeap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import org.slf4j.Logger;

public class EnderDragon
extends Mob
implements Enemy {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final EntityDataAccessor<Integer> DATA_PHASE = SynchedEntityData.defineId(EnderDragon.class, EntityDataSerializers.INT);
    private static final TargetingConditions CRYSTAL_DESTROY_TARGETING = TargetingConditions.forCombat().range(64.0);
    private static final int GROWL_INTERVAL_MIN = 200;
    private static final int GROWL_INTERVAL_MAX = 400;
    private static final float SITTING_ALLOWED_DAMAGE_PERCENTAGE = 0.25f;
    private static final String DRAGON_DEATH_TIME_KEY = "DragonDeathTime";
    private static final String DRAGON_PHASE_KEY = "DragonPhase";
    private static final int DEFAULT_DEATH_TIME = 0;
    public final DragonFlightHistory flightHistory = new DragonFlightHistory();
    private final EnderDragonPart[] subEntities;
    public final EnderDragonPart head;
    private final EnderDragonPart neck;
    private final EnderDragonPart body;
    private final EnderDragonPart tail1;
    private final EnderDragonPart tail2;
    private final EnderDragonPart tail3;
    private final EnderDragonPart wing1;
    private final EnderDragonPart wing2;
    public float oFlapTime;
    public float flapTime;
    public boolean inWall;
    public int dragonDeathTime = 0;
    public float yRotA;
    @Nullable
    public EndCrystal nearestCrystal;
    @Nullable
    private EndDragonFight dragonFight;
    private BlockPos fightOrigin = BlockPos.ZERO;
    private final EnderDragonPhaseManager phaseManager;
    private int growlTime = 100;
    private float sittingDamageReceived;
    private final Node[] nodes = new Node[24];
    private final int[] nodeAdjacency = new int[24];
    private final BinaryHeap openSet = new BinaryHeap();
    @Nullable
    private EntityReference<Player> unlimitedLastHurtByPlayer = null;

    public EnderDragon(EntityType<? extends EnderDragon> p_31096_, Level p_31097_) {
        super((EntityType<? extends Mob>)EntityType.ENDER_DRAGON, p_31097_);
        this.head = new EnderDragonPart(this, "head", 1.0f, 1.0f);
        this.neck = new EnderDragonPart(this, "neck", 3.0f, 3.0f);
        this.body = new EnderDragonPart(this, "body", 5.0f, 3.0f);
        this.tail1 = new EnderDragonPart(this, "tail", 2.0f, 2.0f);
        this.tail2 = new EnderDragonPart(this, "tail", 2.0f, 2.0f);
        this.tail3 = new EnderDragonPart(this, "tail", 2.0f, 2.0f);
        this.wing1 = new EnderDragonPart(this, "wing", 4.0f, 2.0f);
        this.wing2 = new EnderDragonPart(this, "wing", 4.0f, 2.0f);
        this.subEntities = new EnderDragonPart[]{this.head, this.neck, this.body, this.tail1, this.tail2, this.tail3, this.wing1, this.wing2};
        this.setHealth(this.getMaxHealth());
        this.noPhysics = true;
        this.phaseManager = new EnderDragonPhaseManager(this);
        this.setId(ENTITY_COUNTER.getAndAdd(this.subEntities.length + 1) + 1);
    }

    @Override
    public void setId(int p_20235_) {
        super.setId(p_20235_);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].setId(p_20235_ + i + 1);
        }
    }

    public void setDragonFight(EndDragonFight p_287736_) {
        this.dragonFight = p_287736_;
    }

    public void setFightOrigin(BlockPos p_287665_) {
        this.fightOrigin = p_287665_;
    }

    public BlockPos getFightOrigin() {
        return this.fightOrigin;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 200.0).add(Attributes.CAMERA_DISTANCE, 16.0);
    }

    @Override
    public boolean isFlapping() {
        float f = Mth.cos(this.flapTime * ((float)Math.PI * 2));
        float f1 = Mth.cos(this.oFlapTime * ((float)Math.PI * 2));
        return f1 <= -0.3f && f >= -0.3f;
    }

    @Override
    public void onFlap() {
        if (this.level().isClientSide() && !this.isSilent()) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ENDER_DRAGON_FLAP, this.getSoundSource(), 5.0f, 0.8f + this.random.nextFloat() * 0.3f, false);
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_330342_) {
        super.defineSynchedData(p_330342_);
        p_330342_.define(DATA_PHASE, EnderDragonPhase.HOVERING.getId());
    }

    @Nullable
    private Player getUnlimitedLastHurtByPlayer() {
        return EntityReference.get(this.unlimitedLastHurtByPlayer, this.level(), Player.class);
    }

    private boolean isUnlimitedLastHurtByPlayerInvalid() {
        Player player = this.getUnlimitedLastHurtByPlayer();
        return player == null || player.isRemoved();
    }

    @Override
    public void aiStep() {
        ServerLevel serverlevel;
        EndDragonFight enddragonfight;
        Level level;
        if (this.lastHurtByPlayer != null) {
            this.unlimitedLastHurtByPlayer = this.lastHurtByPlayer;
        }
        if (this.isUnlimitedLastHurtByPlayerInvalid()) {
            this.unlimitedLastHurtByPlayer = null;
        }
        this.processFlappingMovement();
        if (this.level().isClientSide()) {
            this.setHealth(this.getHealth());
            if (!this.isSilent() && !this.phaseManager.getCurrentPhase().isSitting() && --this.growlTime < 0) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ENDER_DRAGON_GROWL, this.getSoundSource(), 2.5f, 0.8f + this.random.nextFloat() * 0.3f, false);
                this.growlTime = 200 + this.random.nextInt(200);
            }
        }
        if (this.dragonFight == null && (level = this.level()) instanceof ServerLevel && (enddragonfight = (serverlevel = (ServerLevel)level).getDragonFight()) != null && this.getUUID().equals(enddragonfight.getDragonUUID())) {
            this.dragonFight = enddragonfight;
        }
        this.oFlapTime = this.flapTime;
        if (this.isDeadOrDying()) {
            float f6 = (this.random.nextFloat() - 0.5f) * 8.0f;
            float f8 = (this.random.nextFloat() - 0.5f) * 4.0f;
            float f9 = (this.random.nextFloat() - 0.5f) * 8.0f;
            this.level().addParticle(ParticleTypes.EXPLOSION, this.getX() + (double)f6, this.getY() + 2.0 + (double)f8, this.getZ() + (double)f9, 0.0, 0.0, 0.0);
        } else {
            this.checkCrystals();
            Vec3 vec34 = this.getDeltaMovement();
            float f7 = 0.2f / ((float)vec34.horizontalDistance() * 10.0f + 1.0f);
            this.flapTime = this.phaseManager.getCurrentPhase().isSitting() ? (this.flapTime += 0.1f) : (this.inWall ? (this.flapTime += f7 * 0.5f) : (this.flapTime += (f7 *= (float)Math.pow(2.0, vec34.y))));
            this.setYRot(Mth.wrapDegrees(this.getYRot()));
            if (this.isNoAi()) {
                this.flapTime = 0.5f;
            } else {
                this.flightHistory.record(this.getY(), this.getYRot());
                Level level2 = this.level();
                if (level2 instanceof ServerLevel) {
                    Vec3 vec3;
                    ServerLevel serverlevel1 = (ServerLevel)level2;
                    DragonPhaseInstance dragonphaseinstance = this.phaseManager.getCurrentPhase();
                    dragonphaseinstance.doServerTick(serverlevel1);
                    if (this.phaseManager.getCurrentPhase() != dragonphaseinstance) {
                        dragonphaseinstance = this.phaseManager.getCurrentPhase();
                        dragonphaseinstance.doServerTick(serverlevel1);
                    }
                    if ((vec3 = dragonphaseinstance.getFlyTargetLocation()) != null) {
                        double d0 = vec3.x - this.getX();
                        double d1 = vec3.y - this.getY();
                        double d2 = vec3.z - this.getZ();
                        double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                        float f2 = dragonphaseinstance.getFlySpeed();
                        double d4 = Math.sqrt(d0 * d0 + d2 * d2);
                        if (d4 > 0.0) {
                            d1 = Mth.clamp(d1 / d4, (double)(-f2), (double)f2);
                        }
                        this.setDeltaMovement(this.getDeltaMovement().add(0.0, d1 * 0.01, 0.0));
                        this.setYRot(Mth.wrapDegrees(this.getYRot()));
                        Vec3 vec31 = vec3.subtract(this.getX(), this.getY(), this.getZ()).normalize();
                        Vec3 vec32 = new Vec3(Mth.sin(this.getYRot() * ((float)Math.PI / 180)), this.getDeltaMovement().y, -Mth.cos(this.getYRot() * ((float)Math.PI / 180))).normalize();
                        float f3 = Math.max(((float)vec32.dot(vec31) + 0.5f) / 1.5f, 0.0f);
                        if (Math.abs(d0) > (double)1.0E-5f || Math.abs(d2) > (double)1.0E-5f) {
                            float f4 = Mth.clamp(Mth.wrapDegrees(180.0f - (float)Mth.atan2(d0, d2) * 57.295776f - this.getYRot()), -50.0f, 50.0f);
                            this.yRotA *= 0.8f;
                            this.yRotA += f4 * dragonphaseinstance.getTurnSpeed();
                            this.setYRot(this.getYRot() + this.yRotA * 0.1f);
                        }
                        float f20 = (float)(2.0 / (d3 + 1.0));
                        float f5 = 0.06f;
                        this.moveRelative(0.06f * (f3 * f20 + (1.0f - f20)), new Vec3(0.0, 0.0, -1.0));
                        if (this.inWall) {
                            this.move(MoverType.SELF, this.getDeltaMovement().scale(0.8f));
                        } else {
                            this.move(MoverType.SELF, this.getDeltaMovement());
                        }
                        Vec3 vec33 = this.getDeltaMovement().normalize();
                        double d5 = 0.8 + 0.15 * (vec33.dot(vec32) + 1.0) / 2.0;
                        this.setDeltaMovement(this.getDeltaMovement().multiply(d5, 0.91f, d5));
                    }
                } else {
                    this.interpolation.interpolate();
                    this.phaseManager.getCurrentPhase().doClientTick();
                }
                if (!this.level().isClientSide()) {
                    this.applyEffectsFromBlocks();
                }
                this.yBodyRot = this.getYRot();
                Vec3[] avec3 = new Vec3[this.subEntities.length];
                for (int i = 0; i < this.subEntities.length; ++i) {
                    avec3[i] = new Vec3(this.subEntities[i].getX(), this.subEntities[i].getY(), this.subEntities[i].getZ());
                }
                float f10 = (float)(this.flightHistory.get(5).y() - this.flightHistory.get(10).y()) * 10.0f * ((float)Math.PI / 180);
                float f11 = Mth.cos(f10);
                float f12 = Mth.sin(f10);
                float f = this.getYRot() * ((float)Math.PI / 180);
                float f13 = Mth.sin(f);
                float f1 = Mth.cos(f);
                this.tickPart(this.body, f13 * 0.5f, 0.0, -f1 * 0.5f);
                this.tickPart(this.wing1, f1 * 4.5f, 2.0, f13 * 4.5f);
                this.tickPart(this.wing2, f1 * -4.5f, 2.0, f13 * -4.5f);
                Level level3 = this.level();
                if (level3 instanceof ServerLevel) {
                    ServerLevel serverlevel2 = (ServerLevel)level3;
                    if (this.hurtTime == 0) {
                        this.knockBack(serverlevel2, serverlevel2.getEntities(this, this.wing1.getBoundingBox().inflate(4.0, 2.0, 4.0).move(0.0, -2.0, 0.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                        this.knockBack(serverlevel2, serverlevel2.getEntities(this, this.wing2.getBoundingBox().inflate(4.0, 2.0, 4.0).move(0.0, -2.0, 0.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                        this.hurt(serverlevel2, serverlevel2.getEntities(this, this.head.getBoundingBox().inflate(1.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                        this.hurt(serverlevel2, serverlevel2.getEntities(this, this.neck.getBoundingBox().inflate(1.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                    }
                }
                float f14 = Mth.sin(this.getYRot() * ((float)Math.PI / 180) - this.yRotA * 0.01f);
                float f15 = Mth.cos(this.getYRot() * ((float)Math.PI / 180) - this.yRotA * 0.01f);
                float f16 = this.getHeadYOffset();
                this.tickPart(this.head, f14 * 6.5f * f11, f16 + f12 * 6.5f, -f15 * 6.5f * f11);
                this.tickPart(this.neck, f14 * 5.5f * f11, f16 + f12 * 5.5f, -f15 * 5.5f * f11);
                DragonFlightHistory.Sample dragonflighthistory$sample = this.flightHistory.get(5);
                for (int j = 0; j < 3; ++j) {
                    EnderDragonPart enderdragonpart = null;
                    if (j == 0) {
                        enderdragonpart = this.tail1;
                    }
                    if (j == 1) {
                        enderdragonpart = this.tail2;
                    }
                    if (j == 2) {
                        enderdragonpart = this.tail3;
                    }
                    DragonFlightHistory.Sample dragonflighthistory$sample1 = this.flightHistory.get(12 + j * 2);
                    float f17 = this.getYRot() * ((float)Math.PI / 180) + this.rotWrap(dragonflighthistory$sample1.yRot() - dragonflighthistory$sample.yRot()) * ((float)Math.PI / 180);
                    float f18 = Mth.sin(f17);
                    float f19 = Mth.cos(f17);
                    float f21 = 1.5f;
                    float f22 = (float)(j + 1) * 2.0f;
                    this.tickPart(enderdragonpart, -(f13 * 1.5f + f18 * f22) * f11, dragonflighthistory$sample1.y() - dragonflighthistory$sample.y() - (double)((f22 + 1.5f) * f12) + 1.5, (f1 * 1.5f + f19 * f22) * f11);
                }
                Level level4 = this.level();
                if (level4 instanceof ServerLevel) {
                    ServerLevel serverlevel3 = (ServerLevel)level4;
                    this.inWall = this.checkWalls(serverlevel3, this.head.getBoundingBox()) | this.checkWalls(serverlevel3, this.neck.getBoundingBox()) | this.checkWalls(serverlevel3, this.body.getBoundingBox());
                    if (this.dragonFight != null) {
                        this.dragonFight.updateDragon(this);
                    }
                }
                for (int k = 0; k < this.subEntities.length; ++k) {
                    this.subEntities[k].xo = avec3[k].x;
                    this.subEntities[k].yo = avec3[k].y;
                    this.subEntities[k].zo = avec3[k].z;
                    this.subEntities[k].xOld = avec3[k].x;
                    this.subEntities[k].yOld = avec3[k].y;
                    this.subEntities[k].zOld = avec3[k].z;
                }
            }
        }
    }

    private void tickPart(EnderDragonPart p_31116_, double p_31117_, double p_31118_, double p_31119_) {
        p_31116_.setPos(this.getX() + p_31117_, this.getY() + p_31118_, this.getZ() + p_31119_);
    }

    private float getHeadYOffset() {
        if (this.phaseManager.getCurrentPhase().isSitting()) {
            return -1.0f;
        }
        DragonFlightHistory.Sample dragonflighthistory$sample = this.flightHistory.get(5);
        DragonFlightHistory.Sample dragonflighthistory$sample1 = this.flightHistory.get(0);
        return (float)(dragonflighthistory$sample.y() - dragonflighthistory$sample1.y());
    }

    private void checkCrystals() {
        if (this.nearestCrystal != null) {
            if (this.nearestCrystal.isRemoved()) {
                this.nearestCrystal = null;
            } else if (this.tickCount % 10 == 0 && this.getHealth() < this.getMaxHealth()) {
                this.setHealth(this.getHealth() + 1.0f);
            }
        }
        if (this.random.nextInt(10) == 0) {
            List list = this.level().getEntitiesOfClass(EndCrystal.class, this.getBoundingBox().inflate(32.0));
            EndCrystal endcrystal = null;
            double d0 = Double.MAX_VALUE;
            for (EndCrystal endcrystal1 : list) {
                double d1 = endcrystal1.distanceToSqr(this);
                if (!(d1 < d0)) continue;
                d0 = d1;
                endcrystal = endcrystal1;
            }
            this.nearestCrystal = endcrystal;
        }
    }

    private void knockBack(ServerLevel p_343522_, List<Entity> p_31132_) {
        double d0 = (this.body.getBoundingBox().minX + this.body.getBoundingBox().maxX) / 2.0;
        double d1 = (this.body.getBoundingBox().minZ + this.body.getBoundingBox().maxZ) / 2.0;
        for (Entity entity : p_31132_) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingentity = (LivingEntity)entity;
            double d2 = entity.getX() - d0;
            double d3 = entity.getZ() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.push(d2 / d4 * 4.0, 0.2f, d3 / d4 * 4.0);
            if (this.phaseManager.getCurrentPhase().isSitting() || livingentity.getLastHurtByMobTimestamp() >= entity.tickCount - 2) continue;
            DamageSource damagesource = this.damageSources().mobAttack(this);
            entity.hurtServer(p_343522_, damagesource, 5.0f);
            EnchantmentHelper.doPostAttackEffects(p_343522_, entity, damagesource);
        }
    }

    private void hurt(ServerLevel p_366619_, List<Entity> p_361288_) {
        for (Entity entity : p_361288_) {
            if (!(entity instanceof LivingEntity)) continue;
            DamageSource damagesource = this.damageSources().mobAttack(this);
            entity.hurtServer(p_366619_, damagesource, 10.0f);
            EnchantmentHelper.doPostAttackEffects(p_366619_, entity, damagesource);
        }
    }

    private float rotWrap(double p_31165_) {
        return (float)Mth.wrapDegrees(p_31165_);
    }

    private boolean checkWalls(ServerLevel p_363273_, AABB p_31140_) {
        int i = Mth.floor(p_31140_.minX);
        int j = Mth.floor(p_31140_.minY);
        int k = Mth.floor(p_31140_.minZ);
        int l = Mth.floor(p_31140_.maxX);
        int i1 = Mth.floor(p_31140_.maxY);
        int j1 = Mth.floor(p_31140_.maxZ);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    BlockState blockstate = p_363273_.getBlockState(blockpos);
                    if (blockstate.isAir() || blockstate.is(BlockTags.DRAGON_TRANSPARENT)) continue;
                    if (ForgeHooks.canEntityDestroy((ServerLevel)p_363273_, (BlockPos)blockpos, (LivingEntity)this) && !blockstate.is(BlockTags.DRAGON_IMMUNE)) {
                        flag1 = p_363273_.removeBlock(blockpos, false) || flag1;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            BlockPos blockpos1 = new BlockPos(i + this.random.nextInt(l - i + 1), j + this.random.nextInt(i1 - j + 1), k + this.random.nextInt(j1 - k + 1));
            p_363273_.levelEvent(2008, blockpos1, 0);
        }
        return flag;
    }

    public boolean hurt(ServerLevel p_363622_, EnderDragonPart p_361953_, DamageSource p_369686_, float p_362736_) {
        if (this.phaseManager.getCurrentPhase().getPhase() == EnderDragonPhase.DYING) {
            return false;
        }
        p_362736_ = this.phaseManager.getCurrentPhase().onHurt(p_369686_, p_362736_);
        if (p_361953_ != this.head) {
            p_362736_ = p_362736_ / 4.0f + Math.min(p_362736_, 1.0f);
        }
        if (p_362736_ < 0.01f) {
            return false;
        }
        if (p_369686_.getEntity() instanceof Player || p_369686_.is(DamageTypeTags.ALWAYS_HURTS_ENDER_DRAGONS)) {
            float f = this.getHealth();
            this.reallyHurt(p_363622_, p_369686_, p_362736_);
            if (this.isDeadOrDying() && !this.phaseManager.getCurrentPhase().isSitting()) {
                this.setHealth(1.0f);
                this.phaseManager.setPhase(EnderDragonPhase.DYING);
            }
            if (this.phaseManager.getCurrentPhase().isSitting()) {
                this.sittingDamageReceived = this.sittingDamageReceived + f - this.getHealth();
                if (this.sittingDamageReceived > 0.25f * this.getMaxHealth()) {
                    this.sittingDamageReceived = 0.0f;
                    this.phaseManager.setPhase(EnderDragonPhase.TAKEOFF);
                }
            }
        }
        return true;
    }

    @Override
    public boolean hurtServer(ServerLevel p_364327_, DamageSource p_363284_, float p_360908_) {
        return this.hurt(p_364327_, this.body, p_363284_, p_360908_);
    }

    protected void reallyHurt(ServerLevel p_360975_, DamageSource p_31162_, float p_31163_) {
        super.hurtServer(p_360975_, p_31162_, p_31163_);
    }

    @Override
    public void kill(ServerLevel p_364941_) {
        this.remove(Entity.RemovalReason.KILLED);
        this.gameEvent(GameEvent.ENTITY_DIE);
        if (this.dragonFight != null) {
            this.dragonFight.updateDragon(this);
            this.dragonFight.setDragonKilled(this);
        }
    }

    @Override
    protected void tickDeath() {
        Level level;
        Level f22;
        if (this.dragonFight != null) {
            this.dragonFight.updateDragon(this);
        }
        ++this.dragonDeathTime;
        if (this.dragonDeathTime >= 180 && this.dragonDeathTime <= 200) {
            float f = (this.random.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.random.nextFloat() - 0.5f) * 4.0f;
            float f22 = (this.random.nextFloat() - 0.5f) * 8.0f;
            this.level().addParticle(ParticleTypes.EXPLOSION_EMITTER, this.getX() + (double)f, this.getY() + 2.0 + (double)f1, this.getZ() + (double)f22, 0.0, 0.0, 0.0);
        }
        int i = 500;
        if (this.dragonFight != null && !this.dragonFight.hasPreviouslyKilledDragon()) {
            i = 12000;
        }
        if ((f22 = this.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)f22;
            if (this.dragonDeathTime > 150 && this.dragonDeathTime % 5 == 0 && serverlevel.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
                int award = ForgeEventFactory.getExperienceDrop((LivingEntity)this, (Player)this.getUnlimitedLastHurtByPlayer(), (int)Mth.floor((float)i * 0.08f));
                ExperienceOrb.award(serverlevel, this.position(), award);
            }
            if (this.dragonDeathTime == 1 && !this.isSilent()) {
                serverlevel.globalLevelEvent(1028, this.blockPosition(), 0);
            }
        }
        Vec3 vec3 = new Vec3(0.0, 0.1f, 0.0);
        this.move(MoverType.SELF, vec3);
        for (EnderDragonPart enderdragonpart : this.subEntities) {
            enderdragonpart.setOldPosAndRot();
            enderdragonpart.setPos(enderdragonpart.position().add(vec3));
        }
        if (this.dragonDeathTime == 200 && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverlevel1 = (ServerLevel)level;
            if (serverlevel1.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
                int award = ForgeEventFactory.getExperienceDrop((LivingEntity)this, (Player)this.getUnlimitedLastHurtByPlayer(), (int)Mth.floor((float)i * 0.2f));
                ExperienceOrb.award(serverlevel1, this.position(), award);
            }
            if (this.dragonFight != null) {
                this.dragonFight.setDragonKilled(this);
            }
            this.remove(Entity.RemovalReason.KILLED);
            this.gameEvent(GameEvent.ENTITY_DIE);
        }
    }

    public int findClosestNode() {
        if (this.nodes[0] == null) {
            for (int i = 0; i < 24; ++i) {
                int i1;
                int l;
                int j = 5;
                if (i < 12) {
                    l = Mth.floor(60.0f * Mth.cos(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i)));
                    i1 = Mth.floor(60.0f * Mth.sin(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i)));
                } else if (i < 20) {
                    int $$2 = i - 12;
                    l = Mth.floor(40.0f * Mth.cos(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)$$2)));
                    i1 = Mth.floor(40.0f * Mth.sin(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)$$2)));
                    j += 10;
                } else {
                    int k1 = i - 20;
                    l = Mth.floor(20.0f * Mth.cos(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)k1)));
                    i1 = Mth.floor(20.0f * Mth.sin(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)k1)));
                }
                int j1 = Math.max(73, this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(l, 0, i1)).getY() + j);
                this.nodes[i] = new Node(l, j1, i1);
            }
            this.nodeAdjacency[0] = 6146;
            this.nodeAdjacency[1] = 8197;
            this.nodeAdjacency[2] = 8202;
            this.nodeAdjacency[3] = 16404;
            this.nodeAdjacency[4] = 32808;
            this.nodeAdjacency[5] = 32848;
            this.nodeAdjacency[6] = 65696;
            this.nodeAdjacency[7] = 131392;
            this.nodeAdjacency[8] = 131712;
            this.nodeAdjacency[9] = 263424;
            this.nodeAdjacency[10] = 526848;
            this.nodeAdjacency[11] = 525313;
            this.nodeAdjacency[12] = 1581057;
            this.nodeAdjacency[13] = 3166214;
            this.nodeAdjacency[14] = 2138120;
            this.nodeAdjacency[15] = 6373424;
            this.nodeAdjacency[16] = 4358208;
            this.nodeAdjacency[17] = 12910976;
            this.nodeAdjacency[18] = 9044480;
            this.nodeAdjacency[19] = 9706496;
            this.nodeAdjacency[20] = 15216640;
            this.nodeAdjacency[21] = 0xD0E000;
            this.nodeAdjacency[22] = 11763712;
            this.nodeAdjacency[23] = 0x7E0000;
        }
        return this.findClosestNode(this.getX(), this.getY(), this.getZ());
    }

    public int findClosestNode(double p_31171_, double p_31172_, double p_31173_) {
        float f = 10000.0f;
        int i = 0;
        Node node = new Node(Mth.floor(p_31171_), Mth.floor(p_31172_), Mth.floor(p_31173_));
        int j = 0;
        if (this.dragonFight == null || this.dragonFight.getCrystalsAlive() == 0) {
            j = 12;
        }
        for (int k = j; k < 24; ++k) {
            float f1;
            if (this.nodes[k] == null || !((f1 = this.nodes[k].distanceToSqr(node)) < f)) continue;
            f = f1;
            i = k;
        }
        return i;
    }

    @Nullable
    public Path findPath(int p_31105_, int p_31106_, @Nullable Node p_31107_) {
        for (int i = 0; i < 24; ++i) {
            Node node = this.nodes[i];
            node.closed = false;
            node.f = 0.0f;
            node.g = 0.0f;
            node.h = 0.0f;
            node.cameFrom = null;
            node.heapIdx = -1;
        }
        Node node4 = this.nodes[p_31105_];
        Node node5 = this.nodes[p_31106_];
        node4.g = 0.0f;
        node4.f = node4.h = node4.distanceTo(node5);
        this.openSet.clear();
        this.openSet.insert(node4);
        Node node1 = node4;
        int j = 0;
        if (this.dragonFight == null || this.dragonFight.getCrystalsAlive() == 0) {
            j = 12;
        }
        while (!this.openSet.isEmpty()) {
            Node node2 = this.openSet.pop();
            if (node2.equals(node5)) {
                if (p_31107_ != null) {
                    p_31107_.cameFrom = node5;
                    node5 = p_31107_;
                }
                return this.reconstructPath(node4, node5);
            }
            if (node2.distanceTo(node5) < node1.distanceTo(node5)) {
                node1 = node2;
            }
            node2.closed = true;
            int k = 0;
            for (int l = 0; l < 24; ++l) {
                if (this.nodes[l] != node2) continue;
                k = l;
                break;
            }
            for (int i1 = j; i1 < 24; ++i1) {
                if ((this.nodeAdjacency[k] & 1 << i1) <= 0) continue;
                Node node3 = this.nodes[i1];
                if (node3.closed) continue;
                float f = node2.g + node2.distanceTo(node3);
                if (node3.inOpenSet() && !(f < node3.g)) continue;
                node3.cameFrom = node2;
                node3.g = f;
                node3.h = node3.distanceTo(node5);
                if (node3.inOpenSet()) {
                    this.openSet.changeCost(node3, node3.g + node3.h);
                    continue;
                }
                node3.f = node3.g + node3.h;
                this.openSet.insert(node3);
            }
        }
        if (node1 == node4) {
            return null;
        }
        LOGGER.debug("Failed to find path from {} to {}", (Object)p_31105_, (Object)p_31106_);
        if (p_31107_ != null) {
            p_31107_.cameFrom = node1;
            node1 = p_31107_;
        }
        return this.reconstructPath(node4, node1);
    }

    private Path reconstructPath(Node p_31129_, Node p_31130_) {
        ArrayList list = Lists.newArrayList();
        Node node = p_31130_;
        list.add(0, p_31130_);
        while (node.cameFrom != null) {
            node = node.cameFrom;
            list.add(0, node);
        }
        return new Path(list, new BlockPos(p_31130_.x, p_31130_.y, p_31130_.z), true);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput p_406735_) {
        super.addAdditionalSaveData(p_406735_);
        p_406735_.putInt(DRAGON_PHASE_KEY, this.phaseManager.getCurrentPhase().getPhase().getId());
        p_406735_.putInt(DRAGON_DEATH_TIME_KEY, this.dragonDeathTime);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput p_406699_) {
        super.readAdditionalSaveData(p_406699_);
        p_406699_.getInt(DRAGON_PHASE_KEY).ifPresent(p_395552_ -> this.phaseManager.setPhase(EnderDragonPhase.getById(p_395552_)));
        this.dragonDeathTime = p_406699_.getIntOr(DRAGON_DEATH_TIME_KEY, 0);
    }

    @Override
    public void checkDespawn() {
    }

    public EnderDragonPart[] getSubEntities() {
        return this.subEntities;
    }

    @Override
    public boolean isPickable() {
        return false;
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENDER_DRAGON_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource p_31154_) {
        return SoundEvents.ENDER_DRAGON_HURT;
    }

    @Override
    protected float getSoundVolume() {
        return 5.0f;
    }

    public Vec3 getHeadLookVector(float p_31175_) {
        Vec3 vec3;
        DragonPhaseInstance dragonphaseinstance = this.phaseManager.getCurrentPhase();
        EnderDragonPhase<? extends DragonPhaseInstance> enderdragonphase = dragonphaseinstance.getPhase();
        if (enderdragonphase == EnderDragonPhase.LANDING || enderdragonphase == EnderDragonPhase.TAKEOFF) {
            BlockPos blockpos = this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.getLocation(this.fightOrigin));
            float f5 = Math.max((float)Math.sqrt(blockpos.distToCenterSqr(this.position())) / 4.0f, 1.0f);
            float f2 = 6.0f / f5;
            float f3 = this.getXRot();
            float f4 = 1.5f;
            this.setXRot(-f2 * 1.5f * 5.0f);
            vec3 = this.getViewVector(p_31175_);
            this.setXRot(f3);
        } else if (dragonphaseinstance.isSitting()) {
            float f = this.getXRot();
            float f1 = 1.5f;
            this.setXRot(-45.0f);
            vec3 = this.getViewVector(p_31175_);
            this.setXRot(f);
        } else {
            vec3 = this.getViewVector(p_31175_);
        }
        return vec3;
    }

    public void onCrystalDestroyed(ServerLevel p_365946_, EndCrystal p_31125_, BlockPos p_31126_, DamageSource p_31127_) {
        Player player1;
        Entity entity = p_31127_.getEntity();
        Player player = entity instanceof Player ? (player1 = (Player)entity) : p_365946_.getNearestPlayer(CRYSTAL_DESTROY_TARGETING, p_31126_.getX(), p_31126_.getY(), p_31126_.getZ());
        if (p_31125_ == this.nearestCrystal) {
            this.hurt(p_365946_, this.head, this.damageSources().explosion(p_31125_, player), 10.0f);
        }
        this.phaseManager.getCurrentPhase().onCrystalDestroyed(p_31125_, p_31126_, p_31127_, player);
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> p_31136_) {
        if (DATA_PHASE.equals(p_31136_) && this.level().isClientSide()) {
            this.phaseManager.setPhase(EnderDragonPhase.getById(this.getEntityData().get(DATA_PHASE)));
        }
        super.onSyncedDataUpdated(p_31136_);
    }

    public EnderDragonPhaseManager getPhaseManager() {
        return this.phaseManager;
    }

    @Nullable
    public EndDragonFight getDragonFight() {
        return this.dragonFight;
    }

    @Override
    public boolean addEffect(MobEffectInstance p_182394_, @Nullable Entity p_182395_) {
        return false;
    }

    @Override
    protected boolean canRide(Entity p_31169_) {
        return false;
    }

    @Override
    public boolean canUsePortal(boolean p_342758_) {
        return false;
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket p_218825_) {
        super.recreateFromPacket(p_218825_);
    }

    @Override
    public boolean canAttack(LivingEntity p_149576_) {
        return p_149576_.canBeSeenAsEnemy();
    }

    @Override
    protected float sanitizeScale(float p_333905_) {
        return 1.0f;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }
}

