/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import net.minecraftforge.common.IExtensibleEnum;
import org.jetbrains.annotations.Nullable;

public enum PathType implements IExtensibleEnum
{
    BLOCKED(-1.0f),
    OPEN(0.0f),
    WALKABLE(0.0f),
    WALKABLE_DOOR(0.0f),
    TRAPDOOR(0.0f),
    POWDER_SNOW(-1.0f),
    DANGER_POWDER_SNOW(0.0f),
    FENCE(-1.0f),
    LAVA(-1.0f),
    WATER(8.0f),
    WATER_BORDER(8.0f),
    RAIL(0.0f),
    UNPASSABLE_RAIL(-1.0f),
    DANGER_FIRE(8.0f),
    DAMAGE_FIRE(16.0f),
    DANGER_OTHER(8.0f),
    DAMAGE_OTHER(-1.0f),
    DOOR_OPEN(0.0f),
    DOOR_WOOD_CLOSED(-1.0f),
    DOOR_IRON_CLOSED(-1.0f),
    BREACH(4.0f),
    LEAVES(-1.0f),
    STICKY_HONEY(8.0f),
    COCOA(0.0f),
    DAMAGE_CAUTIOUS(0.0f),
    DANGER_TRAPDOOR(0.0f);

    private final float malus;

    private PathType(float p_332471_) {
        this.malus = p_332471_;
    }

    public float getMalus() {
        return this.malus;
    }

    @Nullable
    public PathType getDanger() {
        return this == DAMAGE_FIRE || this == DANGER_FIRE ? DANGER_FIRE : (this == DAMAGE_OTHER || this == DANGER_OTHER ? DANGER_OTHER : (this == LAVA ? DAMAGE_FIRE : null));
    }

    public static PathType create(String name, float malus) {
        throw new IllegalArgumentException("Enum not extended");
    }
}

