/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.entity.ClientMannequin;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelType;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.characteristic.SelfDestructing;
import net.minecraftforge.fml.event.IModBusEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract sealed class EntityRenderersEvent
implements IModBusEvent {
    @ApiStatus.Internal
    protected EntityRenderersEvent() {
    }

    public static final class CreateSkullModels
    extends EntityRenderersEvent {
        private final ImmutableMap.Builder<SkullBlock.Type, Function<EntityModelSet, SkullModelBase>> builder;

        public static EventBus<CreateSkullModels> getBus(BusGroup modBusGroup) {
            return IModBusEvent.getBus((BusGroup)modBusGroup, CreateSkullModels.class);
        }

        @ApiStatus.Internal
        public CreateSkullModels(ImmutableMap.Builder<SkullBlock.Type, Function<EntityModelSet, SkullModelBase>> builder) {
            this.builder = builder;
        }

        public void registerSkullModel(SkullBlock.Type type, Function<EntityModelSet, SkullModelBase> model) {
            this.builder.put((Object)type, model);
        }
    }

    public static final class AddLayers
    extends EntityRenderersEvent {
        private final Map<EntityType<?>, EntityRenderer<?, ?>> renderers;
        private final Map<PlayerModelType, AvatarRenderer<AbstractClientPlayer>> playerRenderers;
        private final Map<PlayerModelType, AvatarRenderer<ClientMannequin>> mannequinRenderers;
        private final EntityRendererProvider.Context context;

        public static EventBus<AddLayers> getBus(BusGroup modBusGroup) {
            return IModBusEvent.getBus((BusGroup)modBusGroup, AddLayers.class);
        }

        @ApiStatus.Internal
        public AddLayers(Map<EntityType<?>, EntityRenderer<?, ?>> renderers, Map<PlayerModelType, AvatarRenderer<AbstractClientPlayer>> playerRenderers, Map<PlayerModelType, AvatarRenderer<ClientMannequin>> mannequinRenderers, EntityRendererProvider.Context context) {
            this.renderers = renderers;
            this.playerRenderers = playerRenderers;
            this.mannequinRenderers = mannequinRenderers;
            this.context = context;
        }

        public Set<PlayerModelType> getModelTypes() {
            return this.playerRenderers.keySet();
        }

        @Nullable
        public <R extends EntityRenderer<? extends Player, ?>> R getPlayerRenderer(PlayerModelType modelType) {
            return (R)((EntityRenderer)this.playerRenderers.get(modelType));
        }

        @Nullable
        public <R extends EntityRenderer<? extends ClientMannequin, ?>> R getMannequinRenderer(PlayerModelType modelType) {
            return (R)((EntityRenderer)this.mannequinRenderers.get(modelType));
        }

        @Nullable
        public <T extends LivingEntity, S extends EntityRenderState, R extends EntityRenderer<T, S>> R getEntityRenderer(EntityType<? extends T> entityType) {
            return (R)this.renderers.get(entityType);
        }

        public EntityModelSet getEntityModels() {
            return this.context.getModelSet();
        }

        public EntityRendererProvider.Context getContext() {
            return this.context;
        }
    }

    public static final class RegisterRenderers
    extends EntityRenderersEvent
    implements SelfDestructing {
        public static EventBus<RegisterRenderers> getBus(BusGroup modBusGroup) {
            return IModBusEvent.getBus((BusGroup)modBusGroup, RegisterRenderers.class);
        }

        @ApiStatus.Internal
        public RegisterRenderers() {
        }

        public <T extends Entity> void registerEntityRenderer(EntityType<? extends T> entityType, EntityRendererProvider<T> entityRendererProvider) {
            EntityRenderers.register(entityType, entityRendererProvider);
        }

        public <T extends BlockEntity, S extends BlockEntityRenderState> void registerBlockEntityRenderer(BlockEntityType<? extends T> blockEntityType, BlockEntityRendererProvider<T, S> blockEntityRendererProvider) {
            BlockEntityRenderers.register(blockEntityType, blockEntityRendererProvider);
        }
    }

    public static final class RegisterLayerDefinitions
    extends EntityRenderersEvent
    implements SelfDestructing {
        public static EventBus<RegisterLayerDefinitions> getBus(BusGroup modBusGroup) {
            return IModBusEvent.getBus((BusGroup)modBusGroup, RegisterLayerDefinitions.class);
        }

        @ApiStatus.Internal
        public RegisterLayerDefinitions() {
        }

        public void registerLayerDefinition(ModelLayerLocation layerLocation, Supplier<LayerDefinition> supplier) {
            ForgeHooksClient.registerLayerDefinition(layerLocation, supplier);
        }
    }
}

