/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface LazyFunction<T, R>
extends Function<T, R> {
    public static <T, R> LazyFunction<T, R> of(@NotNull Function<T, R> function) {
        return new Fast<T, R>(function);
    }

    public static <T, R> LazyFunction<T, R> concurrentOf(@NotNull Function<T, R> function) {
        return new Concurrent<T, R>(function);
    }

    public R get() throws IllegalStateException;

    public static final class Fast<T, R>
    implements LazyFunction<T, R> {
        private Function<T, R> function;
        private R instance;

        private Fast(Function<T, R> function) {
            this.function = function;
        }

        @Override
        @Nullable
        public R apply(T t) {
            if (this.function != null) {
                this.instance = this.function.apply(t);
                this.function = null;
            }
            return this.instance;
        }

        @Override
        public R get() throws IllegalStateException {
            if (this.function != null) {
                throw new IllegalStateException("Cannot call get() before apply()");
            }
            return this.instance;
        }
    }

    public static final class Concurrent<T, R>
    implements LazyFunction<T, R> {
        private volatile Object lock = new Object();
        private volatile Function<T, R> function;
        private volatile R instance;

        private Concurrent(Function<T, R> function) {
            this.function = function;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public R apply(T t) {
            Object localLock = this.lock;
            if (this.function != null) {
                Object object = localLock;
                synchronized (object) {
                    if (this.function != null) {
                        this.instance = this.function.apply(t);
                        this.function = null;
                        this.lock = null;
                    }
                }
            }
            return this.instance;
        }

        @Override
        public R get() throws IllegalStateException {
            if (this.function != null) {
                throw new IllegalStateException("Cannot call get() before apply()");
            }
            return this.instance;
        }
    }
}

