/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.internalapi;

import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.jsonrpc.JsonRpcLogger;
import net.minecraft.server.jsonrpc.internalapi.MinecraftGameRuleService;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.jsonrpc.methods.GameRulesService;
import net.minecraft.server.jsonrpc.methods.InvalidParameterJsonRpcException;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.GameRules;

public class MinecraftGameRuleServiceImpl
implements MinecraftGameRuleService {
    private final DedicatedServer server;
    private final JsonRpcLogger jsonrpcLogger;

    public MinecraftGameRuleServiceImpl(DedicatedServer $$0, JsonRpcLogger $$1) {
        this.server = $$0;
        this.jsonrpcLogger = $$1;
    }

    @Override
    public GameRulesService.TypedRule updateGameRule(GameRulesService.UntypedRule $$0, ClientInfo $$1) {
        GameRules.Value<?> $$2 = this.getRuleValue($$0.key());
        String $$3 = $$2.serialize();
        if ($$2 instanceof GameRules.BooleanValue) {
            GameRules.BooleanValue $$4 = (GameRules.BooleanValue)$$2;
            $$4.set(Boolean.parseBoolean($$0.value()), this.server);
        } else if ($$2 instanceof GameRules.IntegerValue) {
            GameRules.IntegerValue $$5 = (GameRules.IntegerValue)$$2;
            $$5.set(Integer.parseInt($$0.value()), this.server);
        } else {
            throw new InvalidParameterJsonRpcException("Unknown rule type for key: " + $$0.key());
        }
        GameRulesService.TypedRule $$6 = this.getTypedRule($$0.key(), $$2);
        this.jsonrpcLogger.log($$1, "Game rule '{}' updated from '{}' to '{}'", $$6.key(), $$3, $$6.value());
        this.server.onGameRuleChanged($$0.key(), $$2);
        return $$6;
    }

    @Override
    public <T extends GameRules.Value<T>> T getRule(GameRules.Key<T> $$0) {
        return this.server.getGameRules().getRule($$0);
    }

    @Override
    public GameRulesService.TypedRule getTypedRule(String $$0, GameRules.Value<?> $$1) {
        GameRules.Value<?> value = $$1;
        Objects.requireNonNull(value);
        GameRules.Value<?> value2 = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GameRules.BooleanValue.class, GameRules.IntegerValue.class}, value2, n)) {
            case 0 -> {
                GameRules.BooleanValue $$2 = (GameRules.BooleanValue)value2;
                yield new GameRulesService.TypedRule($$0, String.valueOf($$2.get()), GameRulesService.RuleType.BOOL);
            }
            case 1 -> {
                GameRules.IntegerValue $$3 = (GameRules.IntegerValue)value2;
                yield new GameRulesService.TypedRule($$0, String.valueOf($$3.get()), GameRulesService.RuleType.INT);
            }
            default -> throw new InvalidParameterJsonRpcException("Unknown rule type");
        };
    }

    @Override
    public Stream<Map.Entry<GameRules.Key<?>, GameRules.Type<?>>> getAvailableGameRules() {
        FeatureFlagSet $$0 = this.server.getWorldData().getLevelSettings().getDataConfiguration().enabledFeatures();
        return GameRules.availableRules($$0);
    }

    private Optional<GameRules.Key<?>> getRuleKey(String $$0) {
        Stream<Map.Entry<GameRules.Key<?>, GameRules.Type<?>>> $$12 = this.getAvailableGameRules();
        return $$12.filter($$1 -> ((GameRules.Key)$$1.getKey()).getId().equals($$0)).findFirst().map(Map.Entry::getKey);
    }

    private GameRules.Value<?> getRuleValue(String $$0) {
        GameRules.Key<?> $$1 = this.getRuleKey($$0).orElseThrow(() -> new InvalidParameterJsonRpcException("Game rule '" + $$0 + "' does not exist"));
        return this.server.getGameRules().getRule($$1);
    }
}

