/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.RenderTypeGroup;

@Deprecated(forRemoval=true, since="1.21.5")
public interface IModelBuilder<T extends IModelBuilder<T>> {
    public static IModelBuilder<?> of(boolean hasAmbientOcclusion, boolean usesBlockLight, boolean isGui3d, ItemTransforms transforms, TextureAtlasSprite particle) {
        return IModelBuilder.of(hasAmbientOcclusion, usesBlockLight, isGui3d, transforms, particle, RenderTypeGroup.EMPTY);
    }

    public static IModelBuilder<?> of(boolean hasAmbientOcclusion, boolean usesBlockLight, boolean isGui3d, ItemTransforms transforms, TextureAtlasSprite particle, RenderTypeGroup renderTypes) {
        return new Simple(hasAmbientOcclusion, usesBlockLight, isGui3d, transforms, particle, renderTypes);
    }

    public static IModelBuilder<?> of(boolean hasAmbientOcclusion, boolean usesBlockLight, boolean isGui3d, ItemTransforms transforms, TextureAtlasSprite particle, RenderTypeGroup renderTypes, RenderTypeGroup renderTypesFast) {
        return new Simple(hasAmbientOcclusion, usesBlockLight, isGui3d, transforms, particle, renderTypes, renderTypesFast);
    }

    public static IModelBuilder<?> collecting(List<BakedQuad> quads) {
        return new Collecting(quads);
    }

    public T addCulledFace(Direction var1, BakedQuad var2);

    public T addUnculledFace(BakedQuad var1);

    public BlockModelPart build();

    public static class Simple
    implements IModelBuilder<Simple> {
        private final QuadCollection.Builder builder = new QuadCollection.Builder();
        private final boolean hasAmbientOcclusion;
        private final boolean usesBlockLight;
        private final boolean isGui3d;
        private final ItemTransforms transforms;
        private final TextureAtlasSprite particle;
        private final RenderTypeGroup renderTypes;
        private final RenderTypeGroup renderTypesFast;

        private Simple(boolean hasAmbientOcclusion, boolean usesBlockLight, boolean isGui3d, ItemTransforms transforms, TextureAtlasSprite particle, RenderTypeGroup renderTypes) {
            this(hasAmbientOcclusion, usesBlockLight, isGui3d, transforms, particle, renderTypes, RenderTypeGroup.EMPTY);
        }

        private Simple(boolean hasAmbientOcclusion, boolean usesBlockLight, boolean isGui3d, ItemTransforms transforms, TextureAtlasSprite particle, RenderTypeGroup renderTypes, RenderTypeGroup renderTypesFast) {
            this.hasAmbientOcclusion = hasAmbientOcclusion;
            this.usesBlockLight = usesBlockLight;
            this.isGui3d = isGui3d;
            this.transforms = transforms;
            this.particle = particle;
            this.renderTypes = renderTypes;
            this.renderTypesFast = renderTypesFast;
        }

        @Override
        public Simple addCulledFace(Direction facing, BakedQuad quad) {
            this.builder.addCulledFace(facing, quad);
            return this;
        }

        @Override
        public Simple addUnculledFace(BakedQuad quad) {
            this.builder.addUnculledFace(quad);
            return this;
        }

        @Override
        public BlockModelPart build() {
            QuadCollection quads = this.builder.build();
            return new SimpleModelWrapper(quads, this.hasAmbientOcclusion, this.particle);
        }
    }

    public static class Collecting
    implements IModelBuilder<Collecting> {
        private static final BlockModelPart EMPTY = new SimpleModelWrapper(QuadCollection.EMPTY, false, new TextureAtlasSprite(ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"empty"), null, 0, 0, 0, 0){});
        private final List<BakedQuad> quads;

        private Collecting(List<BakedQuad> quads) {
            this.quads = quads;
        }

        @Override
        public Collecting addCulledFace(Direction facing, BakedQuad quad) {
            this.quads.add(quad);
            return this;
        }

        @Override
        public Collecting addUnculledFace(BakedQuad quad) {
            this.quads.add(quad);
            return this;
        }

        @Override
        public BlockModelPart build() {
            return EMPTY;
        }
    }
}

