/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.level;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.random.Weighted;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.SaplingGrowTreeEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.InheritableEvent;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import org.jetbrains.annotations.UnmodifiableView;
import org.jspecify.annotations.NullMarked;

@NullMarked
public sealed interface LevelEvent
extends InheritableEvent
permits ChunkEvent, CreateSpawnPosition, Load, PotentialSpawns, Save, Unload, SaplingGrowTreeEvent, SleepFinishedTimeEvent {
    public static final EventBus<LevelEvent> BUS = EventBus.create(LevelEvent.class);

    public LevelAccessor getLevel();

    public static final class PotentialSpawns
    implements Cancellable,
    LevelEvent {
        public static final CancellableEventBus<PotentialSpawns> BUS = CancellableEventBus.create(PotentialSpawns.class);
        private final LevelAccessor level;
        private final MobCategory mobcategory;
        private final BlockPos pos;
        private final List<Weighted<MobSpawnSettings.SpawnerData>> list;
        private final @UnmodifiableView List<Weighted<// Could not load outer class - annotation placement on inner may be incorrect
        MobSpawnSettings.SpawnerData>> view;

        public PotentialSpawns(LevelAccessor level, MobCategory category, BlockPos pos, WeightedList<MobSpawnSettings.SpawnerData> oldList) {
            this.level = level;
            this.pos = pos;
            this.mobcategory = category;
            this.list = !oldList.isEmpty() ? new ArrayList<Weighted<MobSpawnSettings.SpawnerData>>(oldList.unwrap()) : new ArrayList<Weighted<MobSpawnSettings.SpawnerData>>();
            this.view = Collections.unmodifiableList(this.list);
        }

        @Override
        public LevelAccessor getLevel() {
            return this.level;
        }

        public MobCategory getMobCategory() {
            return this.mobcategory;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public @UnmodifiableView List<Weighted<// Could not load outer class - annotation placement on inner may be incorrect
        MobSpawnSettings.SpawnerData>> getSpawnerDataList() {
            return this.view;
        }

        public void addSpawnerData(MobSpawnSettings.SpawnerData data, int weight) {
            this.list.add((Weighted<MobSpawnSettings.SpawnerData>)new Weighted((Object)data, weight));
        }

        public boolean removeSpawnerData(MobSpawnSettings.SpawnerData data) {
            return this.list.removeIf(weighted -> ((MobSpawnSettings.SpawnerData)weighted.value()).equals((Object)data));
        }
    }

    public record CreateSpawnPosition(LevelAccessor getLevel, ServerLevelData getSettings) implements Cancellable,
    LevelEvent
    {
        public static final CancellableEventBus<CreateSpawnPosition> BUS = CancellableEventBus.create(CreateSpawnPosition.class);
    }

    public record Save(LevelAccessor getLevel) implements LevelEvent
    {
        public static final EventBus<Save> BUS = EventBus.create(Save.class);
    }

    public record Unload(LevelAccessor getLevel) implements LevelEvent
    {
        public static final EventBus<Unload> BUS = EventBus.create(Unload.class);
    }

    public record Load(LevelAccessor getLevel) implements LevelEvent
    {
        public static final EventBus<Load> BUS = EventBus.create(Load.class);
    }
}

