/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.ARGB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ScreenshotEvent;
import net.minecraftforge.eventbus.internal.Event;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class Screenshot {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String SCREENSHOT_DIR = "screenshots";

    public static void grab(File p_92290_, RenderTarget p_92293_, Consumer<Component> p_92294_) {
        Screenshot.grab(p_92290_, null, p_92293_, 1, p_92294_);
    }

    public static void grab(File p_92296_, @Nullable String p_92297_, RenderTarget p_92300_, int p_407783_, Consumer<Component> p_92301_) {
        Screenshot.takeScreenshot(p_92300_, p_407783_, p_389141_ -> {
            File file1 = new File(p_92296_, SCREENSHOT_DIR);
            file1.mkdir();
            File file2 = p_92297_ == null ? Screenshot.getFile(file1) : new File(file1, p_92297_);
            ScreenshotEvent event = new ScreenshotEvent(p_389141_, file2);
            if (ScreenshotEvent.BUS.post((Event)event)) {
                p_92301_.accept(event.getCancelMessage());
                return;
            }
            File target = event.getScreenshotFile();
            Util.ioPool().execute(() -> {
                try {
                    NativeImage $$4x = p_389141_;
                    try {
                        p_389141_.writeToFile(target);
                        MutableComponent component = Component.literal(target.getName()).withStyle(ChatFormatting.UNDERLINE).withStyle(p_389149_ -> p_389149_.withClickEvent(new ClickEvent.OpenFile(file2.getAbsoluteFile())));
                        if (event.getResultMessage() != null) {
                            p_92301_.accept(event.getResultMessage());
                        } else {
                            p_92301_.accept(Component.translatable("screenshot.success", component));
                        }
                    }
                    catch (Throwable throwable1) {
                        if (p_389141_ != null) {
                            try {
                                $$4x.close();
                            }
                            catch (Throwable throwable) {
                                throwable1.addSuppressed(throwable);
                            }
                        }
                        throw throwable1;
                    }
                    if (p_389141_ != null) {
                        p_389141_.close();
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn("Couldn't save screenshot", (Throwable)exception);
                    p_92301_.accept(Component.translatable("screenshot.failure", exception.getMessage()));
                }
            });
        });
    }

    public static void takeScreenshot(RenderTarget p_92282_, Consumer<NativeImage> p_391783_) {
        Screenshot.takeScreenshot(p_92282_, 1, p_391783_);
    }

    public static void takeScreenshot(RenderTarget p_410184_, int p_407182_, Consumer<NativeImage> p_409284_) {
        int i = p_410184_.width;
        int j = p_410184_.height;
        GpuTexture gputexture = p_410184_.getColorTexture();
        if (gputexture == null) {
            throw new IllegalStateException("Tried to capture screenshot of an incomplete framebuffer");
        }
        if (i % p_407182_ != 0 || j % p_407182_ != 0) {
            throw new IllegalArgumentException("Image size is not divisible by downscale factor");
        }
        GpuBuffer gpubuffer = RenderSystem.getDevice().createBuffer(() -> "Screenshot buffer", 9, i * j * gputexture.getFormat().pixelSize());
        CommandEncoder commandencoder = RenderSystem.getDevice().createCommandEncoder();
        RenderSystem.getDevice().createCommandEncoder().copyTextureToBuffer(gputexture, gpubuffer, 0, () -> {
            try (GpuBuffer.MappedView gpubuffer$mappedview = commandencoder.mapBuffer(gpubuffer, true, false);){
                int k = j / p_407182_;
                int l = i / p_407182_;
                NativeImage nativeimage = new NativeImage(l, k, false);
                for (int i1 = 0; i1 < k; ++i1) {
                    for (int j1 = 0; j1 < l; ++j1) {
                        if (p_407182_ == 1) {
                            int i3 = gpubuffer$mappedview.data().getInt((j1 + i1 * i) * gputexture.getFormat().pixelSize());
                            nativeimage.setPixelABGR(j1, j - i1 - 1, i3 | 0xFF000000);
                            continue;
                        }
                        int k1 = 0;
                        int l1 = 0;
                        int i2 = 0;
                        for (int j2 = 0; j2 < p_407182_; ++j2) {
                            for (int k2 = 0; k2 < p_407182_; ++k2) {
                                int l2 = gpubuffer$mappedview.data().getInt((j1 * p_407182_ + j2 + (i1 * p_407182_ + k2) * i) * gputexture.getFormat().pixelSize());
                                k1 += ARGB.red(l2);
                                l1 += ARGB.green(l2);
                                i2 += ARGB.blue(l2);
                            }
                        }
                        int j3 = p_407182_ * p_407182_;
                        nativeimage.setPixelABGR(j1, k - i1 - 1, ARGB.color(255, k1 / j3, l1 / j3, i2 / j3));
                    }
                }
                p_409284_.accept(nativeimage);
            }
            gpubuffer.close();
        }, 0);
    }

    private static File getFile(File p_92288_) {
        String s = Util.getFilenameFormattedDateTime();
        int i = 1;
        File file1;
        while ((file1 = new File(p_92288_, s + (String)(i == 1 ? "" : "_" + i) + ".png")).exists()) {
            ++i;
        }
        return file1;
    }
}

