/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.javafmlmod;

import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import net.minecraftforge.eventbus.api.listener.EventListener;
import net.minecraftforge.eventbus.api.listener.ObjBooleanBiConsumer;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.eventbus.internal.Event;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.IModBusEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.unsafe.UnsafeHacks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;
import org.objectweb.asm.Type;

public final class AutomaticEventSubscriber {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Type AUTO_SUBSCRIBER = Type.getType(Mod.EventBusSubscriber.class);
    private static final Type MOD_TYPE = Type.getType(Mod.class);
    private static final Type ONLY_IN_TYPE = Type.getType(OnlyIn.class);
    private static final List<ModFileScanData.EnumData> DEFAULT_SIDES = List.of(new ModFileScanData.EnumData(null, "CLIENT"), new ModFileScanData.EnumData(null, "DEDICATED_SERVER"));
    private static final ModFileScanData.EnumData DEFAULT_BUS = new ModFileScanData.EnumData(null, "BOTH");

    public static void inject(ModContainer mod, ModFileScanData scanData, ClassLoader loader) {
        if (scanData == null) {
            return;
        }
        LOGGER.debug(Logging.LOADING, "Attempting to inject @EventBusSubscriber classes into the eventbus for {}", (Object)mod.getModId());
        List<ModFileScanData.AnnotationData> targets = scanData.getAnnotations().stream().filter(data -> AUTO_SUBSCRIBER.equals((Object)data.annotationType())).toList();
        Set onlyIns = FMLEnvironment.production ? Collections.emptySet() : scanData.getAnnotations().stream().filter(data -> ONLY_IN_TYPE.equals((Object)data.annotationType())).map(data -> data.clazz().getClassName()).collect(Collectors.toSet());
        Map<String, String> modids = scanData.getAnnotations().stream().filter(data -> MOD_TYPE.equals((Object)data.annotationType())).collect(Collectors.toMap(a -> a.clazz().getClassName(), a -> (String)a.annotationData().get("value")));
        for (ModFileScanData.AnnotationData data2 : targets) {
            if (!FMLEnvironment.production && onlyIns.contains(data2.clazz().getClassName())) {
                throw new RuntimeException("Found @OnlyIn on @EventBusSubscriber class " + data2.clazz().getClassName() + " - this is not allowed as it causes crashes. Remove the OnlyIn and set value=Dist.CLIENT in the EventBusSubscriber annotation instead");
            }
            String modId = modids.getOrDefault(data2.clazz().getClassName(), mod.getModId());
            modId = AutomaticEventSubscriber.value(data2, "modid", modId);
            List<ModFileScanData.EnumData> sidesValue = AutomaticEventSubscriber.value(data2, "value", DEFAULT_SIDES);
            Set sides = sidesValue.stream().map(ModFileScanData.EnumData::value).map(Dist::valueOf).collect(Collectors.toSet());
            String busName = AutomaticEventSubscriber.value(data2, "bus", DEFAULT_BUS).value();
            Mod.EventBusSubscriber.Bus busTarget = Mod.EventBusSubscriber.Bus.valueOf(busName);
            if (!Objects.equals(mod.getModId(), modId) || !sides.contains(FMLEnvironment.dist)) continue;
            try {
                LOGGER.debug(Logging.LOADING, "Auto-subscribing {} to {}", (Object)data2.clazz().getClassName(), (Object)busTarget);
                EventBusSubscriberLogic.register(busTarget.bus().get(), Class.forName(data2.clazz().getClassName(), true, loader));
            }
            catch (ClassNotFoundException e) {
                LOGGER.fatal(Logging.LOADING, "Failed to load mod class {} for @EventBusSubscriber annotation", (Object)data2.clazz(), (Object)e);
                throw new RuntimeException(e);
            }
        }
    }

    private static <R> R value(ModFileScanData.AnnotationData data, String key, R value) {
        return data.annotationData().getOrDefault(key, value);
    }

    private static final class EventBusSubscriberLogic {
        private static final boolean STRICT_RUNTIME_CHECKS = Boolean.getBoolean("eventbus.api.strictRuntimeChecks");
        private static final boolean STRICT_REGISTRATION_CHECKS = STRICT_RUNTIME_CHECKS || Boolean.getBoolean("eventbus.api.strictRegistrationChecks");
        private static final MethodType RETURNS_CONSUMER = MethodType.methodType(Consumer.class);
        private static final MethodType RETURNS_PREDICATE = MethodType.methodType(Predicate.class);
        private static final MethodType RETURNS_MONITOR = MethodType.methodType(ObjBooleanBiConsumer.class);
        private static final MethodType CONSUMER_FI_TYPE = MethodType.methodType(Void.TYPE, Object.class);
        private static final MethodType PREDICATE_FI_TYPE = CONSUMER_FI_TYPE.changeReturnType(Boolean.TYPE);
        private static final MethodType MONITOR_FI_TYPE = MethodType.methodType(Void.TYPE, Object.class, Boolean.TYPE);

        private EventBusSubscriberLogic() {
        }

        public static void register(@Nullable BusGroup busGroup, Class<?> listenerClass) {
            if (STRICT_REGISTRATION_CHECKS) {
                EventBusSubscriberLogic.registerStrict(busGroup, listenerClass);
            } else {
                EventBusSubscriberLogic.registerLenient(busGroup, listenerClass);
            }
        }

        public static void registerLenient(@Nullable BusGroup busGroup, Class<?> listenerClass) {
            Method[] declaredMethods = listenerClass.getDeclaredMethods();
            if (declaredMethods.length == 0) {
                throw new IllegalArgumentException("No declared methods found in " + String.valueOf(listenerClass));
            }
            Class<?> firstValidListenerEventType = null;
            int listenersCount = 0;
            for (Method method : declaredMethods) {
                Class<?> returnType;
                int paramCount;
                if (!Modifier.isStatic(method.getModifiers()) || method.isSynthetic() || (paramCount = method.getParameterCount()) == 0 || paramCount > 2 || (returnType = method.getReturnType()) != Void.TYPE && returnType != Boolean.TYPE || !method.isAnnotationPresent(SubscribeEvent.class)) continue;
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (!Event.class.isAssignableFrom(parameterTypes[0])) {
                    throw new IllegalArgumentException("First parameter of a @SubscribeEvent method must be an event");
                }
                Class<?> eventType = parameterTypes[0];
                SubscribeEvent subscribeEventAnnotation = method.getAnnotation(SubscribeEvent.class);
                EventBusSubscriberLogic.registerListener(busGroup, paramCount, returnType, eventType, subscribeEventAnnotation, method, false);
                ++listenersCount;
                if (firstValidListenerEventType != null) continue;
                firstValidListenerEventType = eventType;
            }
            if (listenersCount == 0) {
                throw new IllegalArgumentException("No listeners found in " + String.valueOf(listenerClass));
            }
            if (firstValidListenerEventType == null) {
                throw new IllegalArgumentException("No valid listeners found in " + String.valueOf(listenerClass));
            }
        }

        public static void registerStrict(BusGroup busGroup, Class<?> listenerClass) {
            Class<?> firstValidListenerEventType = null;
            List<Method> declaredMethods = Arrays.stream(listenerClass.getDeclaredMethods()).filter(Predicate.not(Method::isSynthetic)).toList();
            if (declaredMethods.isEmpty()) {
                String errMsg = "No declared methods found in " + listenerClass.getName();
                Class<?> superClass = listenerClass.getSuperclass();
                if (superClass != null && superClass != Record.class && superClass != Enum.class) {
                    errMsg = errMsg + ". Note that listener inheritance is not supported. If you are trying to inherit listeners, please use @Override and @SubscribeEvent on the method in the subclass.";
                }
                throw EventBusSubscriberLogic.fail(listenerClass, errMsg);
            }
            int listenersCount = 0;
            for (Method method : declaredMethods) {
                boolean isMonitoringPriority;
                boolean hasSubscribeEvent = method.isAnnotationPresent(SubscribeEvent.class);
                int paramCount = method.getParameterCount();
                if (hasSubscribeEvent && (paramCount == 0 || paramCount > 2)) {
                    throw EventBusSubscriberLogic.fail(method, "Invalid number of parameters: " + paramCount + " (expected 1 or 2)");
                }
                if (paramCount == 0) continue;
                Class<?> returnType = method.getReturnType();
                Class<?>[] parameterTypes = method.getParameterTypes();
                boolean firstParamExtendsEvent = Event.class.isAssignableFrom(parameterTypes[0]);
                if (!hasSubscribeEvent && firstParamExtendsEvent) {
                    throw EventBusSubscriberLogic.fail(method, "Missing @SubscribeEvent annotation");
                }
                if (!hasSubscribeEvent) continue;
                boolean firstParamExtendsCancellable = Cancellable.class.isAssignableFrom(parameterTypes[0]);
                SubscribeEvent subscribeEventAnnotation = method.getAnnotation(SubscribeEvent.class);
                boolean bl = isMonitoringPriority = subscribeEventAnnotation.priority() == -128;
                if (!firstParamExtendsEvent) {
                    throw EventBusSubscriberLogic.fail(method, "First parameter of a @SubscribeEvent method must be an event");
                }
                Class<?> eventType = parameterTypes[0];
                if (returnType != Void.TYPE && returnType != Boolean.TYPE) {
                    throw EventBusSubscriberLogic.fail(method, "Invalid return type: " + returnType.getName() + " (expected void or boolean)");
                }
                if (!Modifier.isStatic(method.getModifiers())) {
                    throw EventBusSubscriberLogic.fail(method, "Listener method needs to be static");
                }
                if (isMonitoringPriority && (returnType == Boolean.TYPE || subscribeEventAnnotation.alwaysCancelling())) {
                    throw EventBusSubscriberLogic.fail(method, "Monitoring listeners cannot cancel events");
                }
                if (paramCount == 2) {
                    if (!firstParamExtendsCancellable) {
                        throw EventBusSubscriberLogic.fail(method, "Cancellation-aware monitoring listeners are only valid for cancellable events");
                    }
                    if (!Boolean.TYPE.isAssignableFrom(parameterTypes[1])) {
                        throw EventBusSubscriberLogic.fail(method, "Second parameter of a cancellation-aware monitoring listener must be a boolean");
                    }
                    if (!isMonitoringPriority) {
                        throw EventBusSubscriberLogic.fail(method, "Cancellation-aware monitoring listeners must have a priority of MONITOR");
                    }
                }
                if (!firstParamExtendsCancellable) {
                    if (subscribeEventAnnotation.alwaysCancelling()) {
                        throw EventBusSubscriberLogic.fail(method, "Always cancelling listeners are only valid for cancellable events");
                    }
                    if (returnType == Boolean.TYPE) {
                        throw EventBusSubscriberLogic.fail(method, "Return type boolean is only valid for cancellable events");
                    }
                }
                EventBusSubscriberLogic.registerListener(busGroup, paramCount, returnType, eventType, subscribeEventAnnotation, method, true);
                ++listenersCount;
                if (firstValidListenerEventType != null) continue;
                firstValidListenerEventType = eventType;
            }
            if (listenersCount == 0) {
                throw EventBusSubscriberLogic.fail(listenerClass, "No listeners found");
            }
            if (firstValidListenerEventType == null) {
                throw EventBusSubscriberLogic.fail(listenerClass, "No valid listeners found");
            }
        }

        private static EventListener registerListener(@Nullable BusGroup busGroup, int paramCount, Class<?> returnType, Class<? extends Event> eventType, SubscribeEvent subscribeEventAnnotation, Method method, boolean strict) {
            if (busGroup == null) {
                busGroup = IModBusEvent.class.isAssignableFrom(eventType) ? FMLJavaModLoadingContext.get().getModBusGroup() : BusGroup.DEFAULT;
            } else if (strict) {
                String solution = "To fix this, remove the bus param from your @EventBusSubscriber annotation or move this event listener to another class.";
                boolean isDefaultBusGroup = busGroup == BusGroup.DEFAULT;
                boolean isModBusEvent = IModBusEvent.class.isAssignableFrom(eventType);
                if (isDefaultBusGroup && isModBusEvent) {
                    throw EventBusSubscriberLogic.fail(method, "Event type " + eventType.getName() + " is on the mod BusGroup but you are asking to register it on the default BusGroup (BusGroup.DEFAULT/EventBusSubscriber.Bus.FORGE). " + solution);
                }
                if (!isDefaultBusGroup && !isModBusEvent) {
                    throw EventBusSubscriberLogic.fail(method, "Event type " + eventType.getName() + " is on the default BusGroup but you are asking to register it on the mod BusGroup (context.getModBusGroup()/EventBusSubscriber.Bus.MOD). " + solution);
                }
            }
            if (paramCount == 1) {
                byte priority = subscribeEventAnnotation.priority();
                if (returnType == Void.TYPE) {
                    if (Cancellable.class.isAssignableFrom(eventType)) {
                        CancellableEventBus eventBus = CancellableEventBus.create((BusGroup)busGroup, eventType);
                        if (subscribeEventAnnotation.alwaysCancelling()) {
                            return eventBus.addListener(priority, true, EventBusSubscriberLogic.createConsumer(method));
                        }
                        return eventBus.addListener(priority, EventBusSubscriberLogic.createConsumer(method));
                    }
                    return EventBus.create((BusGroup)busGroup, eventType).addListener(priority, EventBusSubscriberLogic.createConsumer(method));
                }
                if (!Cancellable.class.isAssignableFrom(eventType)) {
                    throw EventBusSubscriberLogic.fail(method, "Return type boolean is only valid for cancellable events");
                }
                if (subscribeEventAnnotation.alwaysCancelling()) {
                    throw new IllegalArgumentException("Always cancelling listeners must have a void return type");
                }
                return CancellableEventBus.create((BusGroup)busGroup, eventType).addListener(priority, EventBusSubscriberLogic.createPredicate(method));
            }
            if (returnType != Void.TYPE) {
                throw new IllegalArgumentException("Cancellation-aware monitoring listeners must have a void return type");
            }
            if (subscribeEventAnnotation.alwaysCancelling()) {
                throw new IllegalArgumentException("Monitoring listeners cannot cancel events");
            }
            return CancellableEventBus.create((BusGroup)busGroup, eventType).addListener(EventBusSubscriberLogic.createMonitor(method));
        }

        private static IllegalArgumentException fail(Class<?> listenerClass, String reason) {
            return new IllegalArgumentException("Failed to register " + listenerClass.getName() + ": " + reason);
        }

        private static IllegalArgumentException fail(Method mtd, String reason) {
            return new IllegalArgumentException("Failed to register " + mtd.getDeclaringClass().getName() + "." + mtd.getName() + ": " + reason);
        }

        private static <T extends Event> Consumer<T> createConsumer(Method callback) {
            MethodHandle factoryMH = EventBusSubscriberLogic.getOrMakeFactory(callback, RETURNS_CONSUMER, CONSUMER_FI_TYPE, "accept");
            try {
                return factoryMH.invokeExact();
            }
            catch (Exception e) {
                throw EventBusSubscriberLogic.makeRuntimeException(callback, e);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        private static <T extends Event> Predicate<T> createPredicate(Method callback) {
            MethodHandle factoryMH = EventBusSubscriberLogic.getOrMakeFactory(callback, RETURNS_PREDICATE, PREDICATE_FI_TYPE, "test");
            try {
                return factoryMH.invokeExact();
            }
            catch (Exception e) {
                throw EventBusSubscriberLogic.makeRuntimeException(callback, e);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        private static <T extends Event> ObjBooleanBiConsumer<T> createMonitor(Method callback) {
            MethodHandle factoryMH = EventBusSubscriberLogic.getOrMakeFactory(callback, RETURNS_MONITOR, MONITOR_FI_TYPE, "accept");
            try {
                return factoryMH.invokeExact();
            }
            catch (Exception e) {
                throw EventBusSubscriberLogic.makeRuntimeException(callback, e);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        private static MethodHandle getOrMakeFactory(Method callback, MethodType factoryReturnType, MethodType fiMethodType, String fiMethodName) {
            return EventBusSubscriberLogic.makeFactory(callback, factoryReturnType, fiMethodType, fiMethodName);
        }

        private static MethodHandle makeFactory(Method callback, MethodType factoryReturnType, MethodType fiMethodType, String fiMethodName) {
            try {
                Class<?> callbackDeclaredClass = callback.getDeclaringClass();
                final class DodgyLookup {
                    private static final MethodHandles.Lookup INSTANCE;

                    private DodgyLookup() {
                    }

                    static {
                        try {
                            Field lookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
                            UnsafeHacks.setAccessible((AccessibleObject)lookupField);
                            INSTANCE = (MethodHandles.Lookup)lookupField.get(null);
                        }
                        catch (IllegalAccessException | NoSuchFieldException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                MethodHandles.Lookup lookup = DodgyLookup.INSTANCE.in(callbackDeclaredClass);
                MethodHandle mh = lookup.unreflect(callback);
                return LambdaMetafactory.metafactory(lookup, fiMethodName, factoryReturnType, fiMethodType, mh, mh.type()).getTarget();
            }
            catch (Exception e) {
                throw EventBusSubscriberLogic.makeRuntimeException(callback, e);
            }
        }

        private static RuntimeException makeRuntimeException(Method callback, Exception e) {
            Exception exception = e;
            Objects.requireNonNull(exception);
            Exception exception2 = exception;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IllegalAccessException.class, NullPointerException.class}, (Object)exception2, n)) {
                case 0 -> {
                    IllegalAccessException iae = (IllegalAccessException)exception2;
                    Object errMsg = "Failed to create listener";
                    if (!Modifier.isPublic(callback.getModifiers())) {
                        errMsg = (String)errMsg + " - is it public?";
                    }
                    yield new RuntimeException((String)errMsg, iae);
                }
                case 1 -> {
                    NullPointerException npe = (NullPointerException)exception2;
                    yield new RuntimeException("Failed to create listener - was given a non-static method without an instance to invoke it with", npe);
                }
                default -> new RuntimeException("Failed to create listener", e);
            };
        }
    }
}

